/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.store.disk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.CachePersistenceException;
import org.ehcache.Status;
import org.ehcache.config.Eviction;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourceType;
import org.ehcache.config.SizedResourcePool;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.spi.service.DiskResourceService;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.service.FileBasedPersistenceContext;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.OperationStatistic;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreConfiguration;
import org.ehcache.impl.internal.events.ThreadLocalStoreEventDispatcher;
import org.ehcache.impl.internal.store.disk.DiskWriteThreadPool;
import org.ehcache.impl.internal.store.disk.EhcachePersistentConcurrentOffHeapClockCache;
import org.ehcache.impl.internal.store.disk.factories.EhcachePersistentSegmentFactory;
import org.ehcache.impl.internal.store.offheap.AbstractOffHeapStore;
import org.ehcache.impl.internal.store.offheap.EhcacheOffHeapBackingMap;
import org.ehcache.impl.internal.store.offheap.OffHeapValueHolder;
import org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.ehcache.impl.internal.store.offheap.portability.SerializerPortability;
import org.ehcache.impl.store.BaseStore;
import org.ehcache.shadow.org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.Persistent;
import org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentPortability;
import org.ehcache.shadow.org.terracotta.offheapstore.disk.storage.FileBackedStorageEngine;
import org.ehcache.shadow.org.terracotta.offheapstore.storage.portability.Portability;
import org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;
import org.ehcache.spi.persistence.PersistableResourceService;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.serialization.SerializationProvider;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.StatefulSerializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffHeapDiskStore<K, V>
extends AbstractOffHeapStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapDiskStore.class);
    private static final String KEY_TYPE_PROPERTY_NAME = "keyType";
    private static final String VALUE_TYPE_PROPERTY_NAME = "valueType";
    protected final AtomicReference<Status> status = new AtomicReference<Status>(Status.UNINITIALIZED);
    private final SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ClassLoader classLoader;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private final long sizeInBytes;
    private final FileBasedPersistenceContext fileBasedPersistenceContext;
    private final ExecutionService executionService;
    private final String threadPoolAlias;
    private final int writerConcurrency;
    private final int diskSegments;
    private volatile EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> map;

    public OffHeapDiskStore(FileBasedPersistenceContext fileBasedPersistenceContext, ExecutionService executionService, String threadPoolAlias, int writerConcurrency, int diskSegments, Store.Configuration<K, V> config, TimeSource timeSource, StoreEventDispatcher<K, V> eventDispatcher, long sizeInBytes, StatisticsService statisticsService) {
        super(config, timeSource, eventDispatcher, statisticsService);
        this.fileBasedPersistenceContext = fileBasedPersistenceContext;
        this.executionService = executionService;
        this.threadPoolAlias = threadPoolAlias;
        this.writerConcurrency = writerConcurrency;
        this.diskSegments = diskSegments;
        EvictionAdvisor<K, V> evictionAdvisor = config.getEvictionAdvisor();
        this.evictionAdvisor = evictionAdvisor != null ? OffHeapDiskStore.wrap(evictionAdvisor) : OffHeapDiskStore.wrap(Eviction.noAdvice());
        this.keyType = config.getKeyType();
        this.valueType = config.getValueType();
        this.classLoader = config.getClassLoader();
        this.keySerializer = config.getKeySerializer();
        this.valueSerializer = config.getValueSerializer();
        this.sizeInBytes = sizeInBytes;
        if (!this.status.compareAndSet(Status.UNINITIALIZED, Status.AVAILABLE)) {
            throw new AssertionError();
        }
    }

    @Override
    protected String getStatisticsTag() {
        return "Disk";
    }

    @Override
    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> getBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        File metadataFile = this.getMetadataFile();
        if (dataFile.isFile() && indexFile.isFile() && metadataFile.isFile()) {
            try {
                return this.recoverBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            return this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> recoverBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) throws IOException {
        File dataFile = this.getDataFile();
        File indexFile = this.getIndexFile();
        File metadataFile = this.getMetadataFile();
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(metadataFile);){
            properties.load(fis);
        }
        try {
            Class<?> persistedKeyType = Class.forName(properties.getProperty(KEY_TYPE_PROPERTY_NAME), false, this.classLoader);
            if (!this.keyType.equals(persistedKeyType)) {
                throw new IllegalArgumentException("Persisted key type '" + persistedKeyType.getName() + "' is not the same as the configured key type '" + this.keyType.getName() + "'");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Persisted key type class not found", cnfe);
        }
        try {
            Class<?> persistedValueType = Class.forName(properties.getProperty(VALUE_TYPE_PROPERTY_NAME), false, this.classLoader);
            if (!this.valueType.equals(persistedValueType)) {
                throw new IllegalArgumentException("Persisted value type '" + persistedValueType.getName() + "' is not the same as the configured value type '" + this.valueType.getName() + "'");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Persisted value type class not found", cnfe);
        }
        try {
            var11_13 = null;
            try (FileInputStream fin = new FileInputStream(indexFile);){
                ObjectInputStream input = new ObjectInputStream(fin);
                long dataTimestampFromIndex = input.readLong();
                long dataTimestampFromFile = dataFile.lastModified();
                long delta = dataTimestampFromFile - dataTimestampFromIndex;
                if (delta < 0L) {
                    LOGGER.info("The index for data file {} is more recent than the data file itself by {}ms : this is harmless.", (Object)dataFile.getName(), (Object)(-delta));
                } else {
                    if (delta > TimeUnit.SECONDS.toMillis(1L)) {
                        LOGGER.warn("The index for data file {} is out of date by {}ms, probably due to an unclean shutdown. Creating a new empty store.", (Object)dataFile.getName(), (Object)delta);
                        EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
                        return ehcachePersistentConcurrentOffHeapClockCache;
                    }
                    if (delta > 0L) {
                        LOGGER.info("The index for data file {} is out of date by {}ms, assuming this small delta is a result of the OS/filesystem.", (Object)dataFile.getName(), (Object)delta);
                    }
                }
                MappedPageSource source = new MappedPageSource(dataFile, false, size);
                try {
                    PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
                    PersistentPortability<V> valuePortability = OffHeapDiskStore.persistent(this.createValuePortability(valueSerializer));
                    DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(this.executionService, this.threadPoolAlias, this.writerConcurrency);
                    Factory<FileBackedStorageEngine<K, V>> storageEngineFactory = FileBackedStorageEngine.createFactory(source, Math.max(size / (long)this.diskSegments / 10L, 1024L), org.ehcache.shadow.org.terracotta.offheapstore.util.MemoryUnit.BYTES, keyPortability, valuePortability, writeWorkers, false);
                    EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionAdvisor, this.mapEvictionListener, false);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> m3 = new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(input, evictionAdvisor, factory);
                    m3.bootstrap(input);
                    EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> ehcachePersistentConcurrentOffHeapClockCache = m3;
                    return ehcachePersistentConcurrentOffHeapClockCache;
                }
                catch (IOException e) {
                    try {
                        source.close();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        var11_13 = throwable;
                        throw throwable;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("Index file was corrupt. Deleting data file {}. {}", (Object)dataFile.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.debug("Exception during recovery", e);
            return this.createBackingMap(size, keySerializer, valueSerializer, evictionAdvisor);
        }
    }

    private EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>> createBackingMap(long size, Serializer<K> keySerializer, Serializer<V> valueSerializer, SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor) throws IOException {
        File metadataFile = this.getMetadataFile();
        try (FileOutputStream fos = new FileOutputStream(metadataFile);){
            Properties properties = new Properties();
            properties.put(KEY_TYPE_PROPERTY_NAME, this.keyType.getName());
            properties.put(VALUE_TYPE_PROPERTY_NAME, this.valueType.getName());
            properties.store(fos, "Key and value types");
        }
        MappedPageSource source = new MappedPageSource(this.getDataFile(), size);
        PersistentPortability<K> keyPortability = OffHeapDiskStore.persistent(new SerializerPortability<K>(keySerializer));
        PersistentPortability<V> valuePortability = OffHeapDiskStore.persistent(this.createValuePortability(valueSerializer));
        DiskWriteThreadPool writeWorkers = new DiskWriteThreadPool(this.executionService, this.threadPoolAlias, this.writerConcurrency);
        Factory<FileBackedStorageEngine<K, V>> storageEngineFactory = FileBackedStorageEngine.createFactory(source, Math.max(size / (long)this.diskSegments / 10L, 1024L), org.ehcache.shadow.org.terracotta.offheapstore.util.MemoryUnit.BYTES, keyPortability, valuePortability, writeWorkers, true);
        EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>> factory = new EhcachePersistentSegmentFactory<K, OffHeapValueHolder<V>>(source, storageEngineFactory, 64, evictionAdvisor, this.mapEvictionListener, true);
        return new EhcachePersistentConcurrentOffHeapClockCache<K, OffHeapValueHolder<V>>(evictionAdvisor, factory, this.diskSegments);
    }

    @Override
    protected EhcacheOffHeapBackingMap<K, OffHeapValueHolder<V>> backingMap() {
        return this.map;
    }

    @Override
    protected SwitchableEvictionAdvisor<K, OffHeapValueHolder<V>> evictionAdvisor() {
        return this.evictionAdvisor;
    }

    private File getDataFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.data");
    }

    private File getIndexFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.index");
    }

    private File getMetadataFile() {
        return new File(this.fileBasedPersistenceContext.getDirectory(), "ehcache-disk-store.meta");
    }

    public static <T> PersistentPortability<T> persistent(Portability<T> normal) {
        if (normal instanceof PersistentPortability) {
            return (PersistentPortability)normal;
        }
        LinkedHashSet proxyInterfaces = new LinkedHashSet();
        for (Class<?> klazz = normal.getClass(); klazz != null; klazz = klazz.getSuperclass()) {
            proxyInterfaces.addAll(Arrays.asList(klazz.getInterfaces()));
        }
        proxyInterfaces.add(PersistentPortability.class);
        return (PersistentPortability)Proxy.newProxyInstance(normal.getClass().getClassLoader(), proxyInterfaces.toArray(new Class[0]), (o, method, os) -> {
            if (method.getDeclaringClass().equals(Persistent.class)) {
                return null;
            }
            return method.invoke((Object)normal, os);
        });
    }

    String getThreadPoolAlias() {
        return this.threadPoolAlias;
    }

    int getWriterConcurrency() {
        return this.writerConcurrency;
    }

    int getDiskSegments() {
        return this.diskSegments;
    }

    @ServiceDependencies(value={TimeSourceService.class, SerializationProvider.class, ExecutionService.class, DiskResourceService.class})
    public static class Provider
    extends BaseStore.BaseStoreProvider
    implements AuthoritativeTier.Provider {
        private final Map<OffHeapDiskStore<?, ?>, OperationStatistic<?>[]> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();
        private final Map<Store<?, ?>, PersistableResourceService.PersistenceSpaceIdentifier<?>> createdStores = new ConcurrentWeakIdentityHashMap();
        private final String defaultThreadPool;
        private volatile DiskResourceService diskPersistenceService;

        public Provider() {
            this(null);
        }

        public Provider(String threadPoolAlias) {
            this.defaultThreadPool = threadPoolAlias;
        }

        protected ResourceType<SizedResourcePool> getResourceType() {
            return ResourceType.Core.DISK;
        }

        @Override
        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return resourceTypes.equals(Collections.singleton(this.getResourceType())) ? 1 : 0;
        }

        @Override
        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            return authorityResource.equals(this.getResourceType()) ? 1 : 0;
        }

        public <K, V> OffHeapDiskStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OffHeapDiskStore<K, V> store = this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(store, new OperationStatistic[]{this.createTranslatedStatistic(store, "get", TierOperationOutcomes.GET_TRANSLATION, "get"), this.createTranslatedStatistic(store, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return store;
        }

        private <K, V> OffHeapDiskStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, StoreEventDispatcher<K, V> eventDispatcher, ServiceConfiguration<?, ?> ... serviceConfigs) {
            int diskSegments;
            int writerConcurrency;
            String threadPoolAlias;
            if (this.getServiceProvider() == null) {
                throw new NullPointerException("ServiceProvider is null in OffHeapDiskStore.Provider.");
            }
            TimeSource timeSource = this.getServiceProvider().getService(TimeSourceService.class).getTimeSource();
            ExecutionService executionService = this.getServiceProvider().getService(ExecutionService.class);
            SizedResourcePool diskPool = storeConfig.getResourcePools().getPoolForResource(this.getResourceType());
            if (!(diskPool.getUnit() instanceof MemoryUnit)) {
                throw new IllegalArgumentException("OffHeapDiskStore only supports resources configuration expressed in \"memory\" unit");
            }
            MemoryUnit unit = (MemoryUnit)diskPool.getUnit();
            OffHeapDiskStoreConfiguration config = ServiceUtils.findSingletonAmongst(OffHeapDiskStoreConfiguration.class, serviceConfigs);
            if (config == null) {
                threadPoolAlias = this.defaultThreadPool;
                writerConcurrency = 1;
                diskSegments = 16;
            } else {
                threadPoolAlias = config.getThreadPoolAlias();
                writerConcurrency = config.getWriterConcurrency();
                diskSegments = config.getDiskSegments();
            }
            PersistableResourceService.PersistenceSpaceIdentifier space = ServiceUtils.findSingletonAmongst(PersistableResourceService.PersistenceSpaceIdentifier.class, serviceConfigs);
            if (space == null) {
                throw new IllegalStateException("No LocalPersistenceService could be found - did you configure it at the CacheManager level?");
            }
            try {
                FileBasedPersistenceContext persistenceContext = this.diskPersistenceService.createPersistenceContextWithin(space, "offheap-disk-store");
                OffHeapDiskStore<K, V> offHeapStore = new OffHeapDiskStore<K, V>(persistenceContext, executionService, threadPoolAlias, writerConcurrency, diskSegments, storeConfig, timeSource, eventDispatcher, unit.toBytes(diskPool.getSize()), this.getServiceProvider().getService(StatisticsService.class));
                this.createdStores.put(offHeapStore, space);
                return offHeapStore;
            }
            catch (CachePersistenceException cpex) {
                throw new RuntimeException("Unable to create persistence context in " + space, cpex);
            }
        }

        @Override
        public void releaseStore(Store<?, ?> resource) {
            if (this.createdStores.remove(resource) == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            try {
                OffHeapDiskStore offHeapDiskStore = (OffHeapDiskStore)resource;
                Provider.close(offHeapDiskStore);
                this.getServiceProvider().getService(StatisticsService.class).cleanForNode(offHeapDiskStore);
                this.tierOperationStatistics.remove(offHeapDiskStore);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        static <K, V> void close(OffHeapDiskStore<K, V> resource) throws IOException {
            EhcachePersistentConcurrentOffHeapClockCache localMap = ((OffHeapDiskStore)resource).map;
            if (localMap != null) {
                ((OffHeapDiskStore)resource).map = null;
                localMap.flush();
                try (ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(((OffHeapDiskStore)resource).getIndexFile()));){
                    output.writeLong(System.currentTimeMillis());
                    localMap.persist(output);
                }
                localMap.close();
            }
        }

        @Override
        public void initStore(Store<?, ?> resource) {
            Serializer valueSerializer;
            PersistableResourceService.PersistenceSpaceIdentifier<?> identifier = this.createdStores.get(resource);
            if (identifier == null) {
                throw new IllegalArgumentException("Given store is not managed by this provider : " + resource);
            }
            OffHeapDiskStore diskStore = (OffHeapDiskStore)resource;
            Serializer keySerializer = diskStore.keySerializer;
            if (keySerializer instanceof StatefulSerializer) {
                StateRepository stateRepository;
                try {
                    stateRepository = this.diskPersistenceService.getStateRepositoryWithin(identifier, "key-serializer");
                }
                catch (CachePersistenceException e) {
                    throw new RuntimeException(e);
                }
                ((StatefulSerializer)keySerializer).init(stateRepository);
            }
            if ((valueSerializer = diskStore.valueSerializer) instanceof StatefulSerializer) {
                StateRepository stateRepository;
                try {
                    stateRepository = this.diskPersistenceService.getStateRepositoryWithin(identifier, "value-serializer");
                }
                catch (CachePersistenceException e) {
                    throw new RuntimeException(e);
                }
                ((StatefulSerializer)valueSerializer).init(stateRepository);
            }
            Provider.init(diskStore);
        }

        static <K, V> void init(OffHeapDiskStore<K, V> resource) {
            ((OffHeapDiskStore)resource).map = ((OffHeapDiskStore)resource).getBackingMap(((OffHeapDiskStore)resource).sizeInBytes, ((OffHeapDiskStore)resource).keySerializer, ((OffHeapDiskStore)resource).valueSerializer, ((OffHeapDiskStore)resource).evictionAdvisor);
        }

        @Override
        public void start(ServiceProvider<Service> serviceProvider) {
            super.start(serviceProvider);
            this.diskPersistenceService = serviceProvider.getService(DiskResourceService.class);
            if (this.diskPersistenceService == null) {
                throw new IllegalStateException("Unable to find file based persistence service");
            }
        }

        @Override
        public void stop() {
            try {
                this.createdStores.clear();
                this.diskPersistenceService = null;
            }
            finally {
                super.stop();
            }
        }

        @Override
        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            OffHeapDiskStore<K, V> authoritativeTier = this.createStoreInternal(storeConfig, new ThreadLocalStoreEventDispatcher(storeConfig.getDispatcherConcurrency()), serviceConfigs);
            this.tierOperationStatistics.put(authoritativeTier, new OperationStatistic[]{this.createTranslatedStatistic(authoritativeTier, "get", TierOperationOutcomes.GET_AND_FAULT_TRANSLATION, "getAndFault"), this.createTranslatedStatistic(authoritativeTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return authoritativeTier;
        }

        @Override
        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore(resource);
        }

        @Override
        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore(resource);
        }
    }
}

