/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.vinci.transport.document.XMLToVinci;
import org.apache.vinci.transport.vns.service.Service;
import org.apache.vinci.transport.vns.service.ServiceAlias;
import org.apache.vinci.transport.vns.service.ServiceInterface;
import org.apache.vinci.transport.vns.service.ServiceStack;
import org.apache.vinci.transport.vns.service.ServiceTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ServiceRegistry {
    static int minAutoPort = 10000;
    static int maxAutoPort = 11000;
    static int sizeAutoPort = 10;
    static int MAX_ALIAS_LINKS = 25;
    ServiceTree services = new ServiceTree();
    Hashtable bindings = new Hashtable();

    public void addBinding(Service S) {
        String ip = S.realhost;
        ArrayList<PortRange> v = null;
        if (ip != null) {
            v = (ArrayList<PortRange>)this.bindings.get(ip);
        }
        if (v == null) {
            v = new ArrayList<PortRange>();
        }
        v.add(new PortRange(S.minport, S.maxport));
        this.bindings.put(ip, v);
    }

    public void delBinding(Service S) {
        ArrayList v = (ArrayList)this.bindings.get(S.realhost);
        if (v == null) {
            return;
        }
        v.remove(new PortRange(S.minport, S.maxport));
        if (v.size() < 1) {
            this.bindings.remove(S.realhost);
        }
    }

    public boolean checkConflict(String ip, int min2, int max) {
        ArrayList v = (ArrayList)this.bindings.get(ip);
        if (v == null) {
            return false;
        }
        for (int i = 0; i < v.size(); ++i) {
            PortRange p = (PortRange)v.get(i);
            if ((p.minPort > min2 || min2 > p.maxPort) && (p.minPort > max || max > p.maxPort)) continue;
            return true;
        }
        return false;
    }

    public boolean checkBinding(Service S) {
        String ip;
        Object O;
        if (S.name == null || S.name.trim().equals("")) {
            ServiceRegistry.pr("Service not added: Null name");
            return false;
        }
        int mylevel = this.getLevel(S.name, S.level);
        S.level = "" + mylevel;
        if (this.services.find(S.name) != null && !((O = this.services.find(S.name)) instanceof ServiceAlias)) {
            Service[] objs = ((ServiceStack)O).get("None");
            for (int i = 0; i < objs.length; ++i) {
                Service srv = objs[i];
                if (srv == null || !srv.realhost.equals(S.realhost) || !srv.level.equals(S.level) || srv.instance != S.instance) continue;
                ServiceRegistry.pr("Service not added: Found one with same everything");
                return false;
            }
        }
        if ((ip = S.realhost) == null) {
            ServiceRegistry.pr("No IP provided");
            return false;
        }
        ServiceRegistry.pr("Checking binding for : " + ip);
        if (S.minport <= 0 || S.maxport <= 0) {
            if (!this.bindings.containsKey(ip)) {
                S.minport = minAutoPort;
                S.maxport = minAutoPort + sizeAutoPort - 1;
                ServiceRegistry.pr("Binding not found");
                return true;
            }
            for (int p = minAutoPort; p < maxAutoPort; p += sizeAutoPort) {
                if (this.checkConflict(ip, p, p + sizeAutoPort - 1)) continue;
                S.minport = p;
                S.maxport = p + sizeAutoPort - 1;
                return true;
            }
            return false;
        }
        if (ip == null || !this.bindings.containsKey(ip)) {
            return true;
        }
        return !this.checkConflict(ip, S.minport, S.maxport);
    }

    public boolean addService(Service S) {
        ServiceRegistry.pr("Adding Service : " + S.name);
        if (!this.checkBinding(S)) {
            return false;
        }
        ServiceStack stack = this.getStack(S.name, true);
        if (stack == null) {
            return false;
        }
        stack.add(S);
        this.addBinding(S);
        return true;
    }

    public boolean addAlias(ServiceAlias S) {
        if (this.services.find(S.name) != null) {
            return false;
        }
        if (this.services.find(S.target) == null) {
            return false;
        }
        this.services.setitem(S.name, S);
        return true;
    }

    public boolean delAlias(String name) {
        Object o = this.services.find(name);
        if (o == null || !(o instanceof ServiceAlias)) {
            return false;
        }
        this.services.setitem(name, null);
        return true;
    }

    public boolean addEntry(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ServiceAlias) {
            return this.addAlias((ServiceAlias)o);
        }
        return this.addService((Service)o);
    }

    public boolean updateService(Service S) {
        ServiceStack stack = this.getStack(S.name);
        if (stack == null) {
            return false;
        }
        return stack.update(S);
    }

    public boolean delService(Service S) {
        ServiceStack stack = this.getStack(S.name);
        if (stack == null) {
            return false;
        }
        Object[] dellist = stack.delete(S);
        if (dellist != null) {
            for (int i = 0; i < dellist.length; ++i) {
                this.delBinding((Service)dellist[i]);
            }
            return dellist.length > 0;
        }
        return false;
    }

    public Service[] getServices(String name) {
        return this.getServices(name, null, false);
    }

    public Service[] getServices(String name, String level) {
        return this.getServices(name, level, false);
    }

    public Service[] getServices(String name, int level) {
        return this.getServices(name, "" + level, false);
    }

    public Service[] getServices(String name, int level, boolean resolveAlias) {
        return this.getServices(name, "" + level, resolveAlias);
    }

    public Service[] getServices(String name, String level, boolean resolveAlias) {
        Object O = this.services.find(name);
        if (O != null) {
            if (resolveAlias) {
                for (int i = 0; ServiceAlias.isAlias(O) && i < MAX_ALIAS_LINKS; ++i) {
                    O = this.services.find(((ServiceAlias)O).target);
                }
            }
            if (ServiceAlias.isAlias(O)) {
                return null;
            }
            Service[] temp = ((ServiceStack)O).get(level);
            Service[] result = new Service[temp.length];
            for (int i = 0; i < temp.length; ++i) {
                result[i] = temp[i];
            }
            return result;
        }
        return null;
    }

    int getLevel(String name, String level) {
        ServiceStack S = this.getStack(name);
        if (S == null) {
            return ServiceStack.getAbsLevel(level);
        }
        return S.absLevel(level);
    }

    ServiceStack getStack(String name) {
        return this.getStack(name, false);
    }

    ServiceStack getStack(String name, boolean create) {
        Object o = this.services.find(name);
        if (o == null) {
            if (create) {
                o = new ServiceStack(name);
                this.services.setitem(name, o);
            }
        } else if (o instanceof ServiceAlias) {
            o = null;
        }
        return (ServiceStack)o;
    }

    Object[] getEntries(String name) {
        return this.getEntries(name, -1);
    }

    Object[] getEntries(String name, int level) {
        return this.getEntries(name, "" + level);
    }

    Object[] getEntries(String name, String level) {
        Object o = this.services.find(name);
        if (o == null) {
            return null;
        }
        if (o instanceof ServiceAlias) {
            Object[] result = new Object[]{o};
            return result;
        }
        return ((ServiceStack)o).get(level);
    }

    public Object[] listServices(String prefix, int level) {
        return this.listServices(prefix, "" + level);
    }

    public Object[] listServices(String prefix, String level) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] items = this.services.findprefix(prefix);
        if (items == null) {
            return res.toArray();
        }
        for (int i = 0; i < items.length; ++i) {
            if (ServiceAlias.isAlias(items[i])) {
                res.add(items[i]);
                continue;
            }
            Service[] subitems = ((ServiceStack)items[i]).get(level);
            if (subitems == null) continue;
            for (int j = 0; j < subitems.length; ++j) {
                res.add(subitems[j]);
            }
        }
        return res.toArray();
    }

    public String[] listNames(String prefix, int level) {
        return this.listNames(prefix, "" + level);
    }

    public String[] listNames(String prefix, String level) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<String> res = new ArrayList<String>();
        Object[] items = this.services.findprefix(prefix);
        if (items == null) {
            return new String[0];
        }
        for (int i = 0; i < items.length; ++i) {
            if (ServiceAlias.isAlias(items[i])) {
                res.add(((ServiceAlias)items[i]).name);
            }
            if (level != null && ((ServiceStack)items[i]).isEmpty(level)) continue;
            res.add(((ServiceStack)items[i]).name);
        }
        String[] result = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            result[i] = res.get(i).toString();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String fname) throws Exception {
        Document doc;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            System.err.println("Warning: DocumentBuilderFactory doesn't support the feature http://apache.org/xml/features/disallow-doctype-decl");
        }
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        try (FileReader readme = new FileReader(fname);){
            doc = docBuilder.parse(new InputSource(readme));
        }
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals("CONFIGURATION")) {
            throw new RuntimeException("Illegal file specified");
        }
        NodeList services = doc.getElementsByTagName("SERVICE");
        for (int i = 0; i < services.getLength(); ++i) {
            ServiceInterface S;
            block13: {
                Node N = services.item(i);
                Hashtable<String, Object> H = new Hashtable<String, Object>();
                NodeList children = N.getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node C2 = children.item(j);
                    if (C2.getNodeType() == 3) continue;
                    NodeList subchildren = C2.getChildNodes();
                    if (subchildren.getLength() == 1 && C2.getFirstChild().getNodeType() == 3) {
                        H.put(C2.getNodeName(), C2.getFirstChild().getNodeValue());
                        continue;
                    }
                    H.put(C2.getNodeName(), XMLToVinci.xmlToVinciFrame(new StringReader(ServiceRegistry.constructXMLString(C2, true))));
                }
                if (H.get("TARGET") == null || H.get("NAME") == null) {
                    try {
                        S = new Service(H);
                        break block13;
                    }
                    catch (RuntimeException e) {
                        System.err.println("Got exception while adding Service : " + H.get("NAME").toString());
                        System.err.println("Exception generated : " + e);
                        continue;
                    }
                }
                S = new ServiceAlias((String)H.get("NAME"), (String)H.get("TARGET"));
            }
            this.addEntry(S);
        }
    }

    static String constructXMLString(Node C2, boolean include) {
        if (C2.getNodeType() == 3 || C2.getNodeType() == 4) {
            if (C2.getNodeType() == 4) {
                return "<![CDATA[" + C2.getNodeValue() + "]]>";
            }
            return C2.getNodeValue();
        }
        String result = "";
        if (include) {
            result = result + "<" + C2.getNodeName() + ">";
        }
        NodeList N = C2.getChildNodes();
        for (int i = 0; i < N.getLength(); ++i) {
            result = result + ServiceRegistry.constructXMLString(N.item(i), true);
        }
        if (include) {
            result = result + "</" + C2.getNodeName() + ">";
        }
        return result;
    }

    public void save(Writer F) throws IOException {
        F.write("<CONFIGURATION>\n");
        Object[] objs = this.listServices("", -1);
        if (objs != null) {
            for (int i = 0; i < objs.length; ++i) {
                if (objs[i] == null) continue;
                if (ServiceAlias.isAlias(objs[i])) {
                    F.write(((ServiceAlias)objs[i]).toXML());
                } else {
                    F.write(((Service)objs[i]).toXML());
                }
                F.write("\n");
            }
        }
        F.write("</CONFIGURATION>\n");
    }

    public static void main(String[] args) throws Exception {
        ServiceRegistry SR = new ServiceRegistry();
        SR.load(args[0]);
        FileWriter F = new FileWriter(args[0] + ".bak");
        SR.save(F);
        F.close();
    }

    public static void pr(String s2) {
        System.out.println(s2);
    }

    class PortRange {
        int minPort;
        int maxPort;

        PortRange(int min2, int max) {
            this.minPort = min2;
            this.maxPort = max;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PortRange)) {
                return false;
            }
            PortRange p = (PortRange)o;
            return p.minPort == this.minPort && p.maxPort == this.maxPort;
        }

        public int hashCode() {
            return this.minPort * 31 + this.maxPort;
        }
    }
}

