/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.document;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.debug.FatalException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.XTalkTransporter;
import org.apache.vinci.transport.document.AFrame;
import org.apache.vinci.transport.util.XMLConverter;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLToXTalk {
    private XMLToXTalk() {
    }

    static String convert(String s2) {
        return XMLConverter.simpleConvertStringToXMLString(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void xmlToXTalk(Reader r, String filename, boolean purgeWhitespace, String xml_filename) throws ServiceException, IOException {
        BufferedWriter xml_os = null;
        if (xml_filename != null) {
            xml_os = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xml_filename), "UTF-8"));
        }
        File file = new File(filename);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
        XTalkHandler handler = null;
        try {
            XMLReader xr;
            ((OutputStream)os).write(88);
            ((OutputStream)os).write(0);
            XTalkTransporter.writeInt(1, os);
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                try {
                    spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                }
                catch (SAXNotRecognizedException e) {
                    System.err.println("Warning: SAXParserFactory didn't recognized feature http://apache.org/xml/features/disallow-doctype-decl");
                }
                catch (SAXNotSupportedException e) {
                    System.err.println("Warning: SAXParserFactory doesn't support feature http://apache.org/xml/features/disallow-doctype-decl");
                }
                xr = spf.newSAXParser().getXMLReader();
            }
            catch (SAXException e) {
                throw new ServiceException("Error creating SAX Parser: " + e);
            }
            catch (ParserConfigurationException e) {
                throw new ServiceException("Error creating SAX Parser: " + e);
            }
            if (xml_os != null) {
                xml_os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            try {
                xr.setFeature("http://xml.org/sax/features/namespaces", false);
                handler = new XTalkHandler(os, purgeWhitespace, xml_os);
                xr.setContentHandler(handler);
                xr.setErrorHandler(handler);
                xr.parse(new InputSource(r));
                Debug.p("Final depth: " + handler.depth);
                Debug.p("Final child list size: " + handler.countList.size());
            }
            catch (SAXException e) {
                Debug.reportException(e);
                throw new ServiceException("XML Parse error: " + e);
            }
        }
        finally {
            ((OutputStream)os).close();
            if (xml_os != null) {
                ((Writer)xml_os).close();
            }
        }
        try (RandomAccessFile raf = new RandomAccessFile(filename, "rw");){
            raf.skipBytes(7);
            XMLToXTalk.updateElement(raf, handler.countList, 0);
        }
    }

    private static int updateElement(RandomAccessFile raf, ArrayList counts, int index) throws IOException {
        XMLToXTalk.skipString(raf);
        int skipCount = raf.readInt();
        for (int i = 0; i < skipCount; ++i) {
            XMLToXTalk.skipString(raf);
            XMLToXTalk.skipString(raf);
        }
        int childCount = ((StackEntry)counts.get((int)index)).childCount;
        ++index;
        raf.writeInt(childCount);
        block5: for (int i = 0; i < childCount; ++i) {
            int marker = raf.read();
            switch ((byte)marker) {
                case 69: {
                    index = XMLToXTalk.updateElement(raf, counts, index);
                    continue block5;
                }
                case 115: {
                    XMLToXTalk.skipString(raf);
                    continue block5;
                }
                default: {
                    throw new IOException("Unexepcted marker: " + marker);
                }
            }
        }
        return index;
    }

    private static void skipString(RandomAccessFile raf) throws IOException {
        int skipped;
        int count = raf.readInt();
        if (count != (skipped = raf.skipBytes(count))) {
            throw new RuntimeException(String.format("%d bytes skipped when %d was requested, while reading from stream %s", skipped, count, raf));
        }
    }

    public static void main(String[] args) throws Exception {
        if (args[0].endsWith(".xtalk")) {
            FileInputStream is = new FileInputStream(args[0]);
            AFrame af = new AFrame();
            af.fromStream(is);
            Debug.p(af.toXML());
        } else if (args[0].endsWith(".xml")) {
            FileReader r = new FileReader(args[0]);
            XMLToXTalk.xmlToXTalk(r, "tmp.xtalk", args.length > 1, "tmp.xml");
        } else {
            throw new Exception("Unexpected filename suffix. Provide only .xml or .xtalk");
        }
    }

    private static class XTalkHandler
    extends DefaultHandler {
        protected StackEntry top = null;
        int depth = 0;
        StackEntry[] childrenCount = new StackEntry[6969];
        ArrayList countList = new ArrayList();
        OutputStream os;
        Writer xml_os;
        boolean purgeWhitespace;
        StringBuffer buf = new StringBuffer();

        XTalkHandler(OutputStream os, boolean purgeWhitespace, Writer xml_os) {
            this.os = os;
            this.xml_os = xml_os;
            this.childrenCount[0] = new StackEntry();
            this.purgeWhitespace = purgeWhitespace;
        }

        @Override
        public void startElement(String uri, String name, String qName, Attributes a) {
            this.flushString();
            try {
                if (this.xml_os != null) {
                    this.xml_os.write(60);
                    this.xml_os.write(XMLToXTalk.convert(qName));
                }
                this.os.write(69);
                ++this.childrenCount[this.depth].childCount;
                ++this.depth;
                this.childrenCount[this.depth] = new StackEntry();
                this.countList.add(this.childrenCount[this.depth]);
                XTalkTransporter.stringToBin(qName, this.os);
                XTalkTransporter.writeInt(a.getLength(), this.os);
                for (int i = 0; i < a.getLength(); ++i) {
                    XTalkTransporter.stringToBin(a.getQName(i), this.os);
                    XTalkTransporter.stringToBin(a.getValue(i), this.os);
                    if (this.xml_os == null) continue;
                    this.xml_os.write(32);
                    this.xml_os.write(XMLToXTalk.convert(a.getQName(i)));
                    this.xml_os.write("=\"");
                    this.xml_os.write(XMLToXTalk.convert(a.getValue(i)));
                    this.xml_os.write(34);
                }
                XTalkTransporter.writeInt(69, this.os);
                if (this.xml_os != null) {
                    this.xml_os.write(62);
                }
            }
            catch (IOException e) {
                throw new FatalException(e);
            }
        }

        @Override
        public void endElement(String uri, String name, String qName) {
            this.flushString();
            --this.depth;
            if (this.xml_os != null) {
                try {
                    this.xml_os.write("</");
                    this.xml_os.write(XMLToXTalk.convert(qName));
                    this.xml_os.write(62);
                }
                catch (IOException e) {
                    throw new FatalException(e);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.buf.append(ch, start, length);
        }

        public void flushString() {
            if (this.buf.length() > 0) {
                String s2 = this.buf.toString();
                this.buf.setLength(0);
                if (this.purgeWhitespace) {
                    boolean all_whitespace = true;
                    int length = s2.length();
                    for (int i = 0; i < length; ++i) {
                        if (Character.isWhitespace(s2.charAt(i))) continue;
                        all_whitespace = false;
                        break;
                    }
                    if (all_whitespace) {
                        return;
                    }
                }
                ++this.childrenCount[this.depth].childCount;
                try {
                    this.os.write(115);
                    XTalkTransporter.stringToBin(s2, this.os);
                    if (this.xml_os != null) {
                        this.xml_os.write(XMLToXTalk.convert(s2));
                    }
                }
                catch (IOException e) {
                    throw new FatalException(e);
                }
            }
        }
    }

    private static class StackEntry {
        int childCount;

        private StackEntry() {
        }
    }
}

