/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.merger;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.JarFile;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.tools.pear.merger.PMControllerHelper;
import org.apache.uima.tools.pear.merger.PMUimaAgent;

public class PMController {
    static final String PEAR_MERGER = "PEAR Merger";
    static final String LOG_FILE = "pm.log";
    static final String AGGREGATE_NAME_ARG = "-n";
    static final String AGGREGATE_PEAR_FILE_ARG = "-f";
    private static File[] __pearFiles = null;
    private static String __aggregateName = null;
    private static File __aggregatePearFile = null;
    private static Logger __logger = null;
    private static boolean __logFileEnabled = false;
    private File[] _inpPearFiles = null;
    private String _outAggCompName = null;
    private File _outAggPearFile = null;
    private File _tempWorkDir = null;
    private File _outAggRootDir = null;
    private File[] _outDlgRootDirs = null;
    private InstallationDescriptor[] _dlgInstDescs = null;
    private InstallationDescriptor _outAggInstDesc = null;

    public static void main(String[] args) {
        PMController.setLogFileEnabled(true);
        if (!PMController.parseCommandLine(args)) {
            PMController.logErrorMessage("PEAR Merger terminated: command line error");
            return;
        }
        PMController controller = null;
        try {
            controller = new PMController(__pearFiles, __aggregateName, __aggregatePearFile);
            if (controller.mergePears()) {
                PMController.logInfoMessage("[PEAR Merger]: operation completed successfully");
            } else {
                PMController.logInfoMessage("[PEAR Merger]: operation failed");
            }
        }
        catch (Throwable err) {
            PMController.logErrorMessage("Error in PEAR Merger: " + err.toString());
        }
        finally {
            if (controller != null) {
                try {
                    controller.cleanUp();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Logger getLogger() {
        return __logger;
    }

    public static void logErrorMessage(String message) {
        if (__logFileEnabled) {
            PMController.getLogger().severe(message);
        }
        System.err.println(message);
    }

    public static void logInfoMessage(String message) {
        if (__logFileEnabled) {
            PMController.getLogger().info(message);
        }
        System.out.println(message);
    }

    public static void logWarningMessage(String message) {
        if (__logFileEnabled) {
            PMController.getLogger().warning(message);
        }
        System.err.println(message);
    }

    private static boolean parseCommandLine(String[] args) {
        if (args.length < 4) {
            PMController.logErrorMessage("PEAR Merger args: pear_file_1 ... pear_file_n -n agg_name [-f agg_pear_file]");
            return false;
        }
        ArrayList<File> listOfPears = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(AGGREGATE_NAME_ARG)) {
                if (++i >= args.length) continue;
                __aggregateName = args[i];
                continue;
            }
            if (args[i].equals(AGGREGATE_PEAR_FILE_ARG)) {
                if (++i >= args.length) continue;
                __aggregatePearFile = new File(args[i]);
                continue;
            }
            if (args[i].startsWith("-")) {
                PMController.logErrorMessage("PEAR Merger error: unknown flag '" + args[i] + "'");
                return false;
            }
            File inPear = new File(args[i]);
            if (inPear.isFile()) {
                for (int n = 0; n < listOfPears.size(); ++n) {
                    try {
                        String fPath = ((File)listOfPears.get(n)).getCanonicalPath();
                        String inPath = inPear.getCanonicalPath();
                        if (!fPath.equals(inPath)) continue;
                        PMController.logErrorMessage("PEAR Merger error: duplicated input file " + args[i]);
                        return false;
                    }
                    catch (IOException e) {
                        PMController.logErrorMessage("PEAR Merger error: " + e.toString());
                        return false;
                    }
                }
                listOfPears.add(inPear);
                continue;
            }
            PMController.logErrorMessage("PEAR Merger error: cannot find input file " + args[i]);
            return false;
        }
        if (listOfPears.size() < 2) {
            PMController.logErrorMessage("PEAR Merger error: input PEAR files not specified");
            return false;
        }
        __pearFiles = new File[listOfPears.size()];
        listOfPears.toArray(__pearFiles);
        if (__aggregateName == null) {
            PMController.logErrorMessage("PEAR Merger error: output aggregate name not specified");
            return false;
        }
        return true;
    }

    public static void setLogFileEnabled(boolean enable) {
        Handler[] handlers;
        if (enable && ((handlers = PMController.getLogger().getHandlers()) == null || handlers.length == 0)) {
            try {
                FileHandler fileHandler = new FileHandler(LOG_FILE, false);
                fileHandler.setLevel(Level.ALL);
                fileHandler.setFormatter(new PMLogFormatter());
                PMController.getLogger().addHandler(fileHandler);
            }
            catch (Throwable err) {
                System.err.println("Error initializing log file " + PMController.class.getName() + ": " + err.toString());
            }
        }
        __logFileEnabled = enable;
    }

    public PMController(File[] inpPearFiles, String outCompName, File outPearFile) throws IOException {
        this._inpPearFiles = inpPearFiles;
        this._outAggCompName = outCompName;
        this._outAggPearFile = outPearFile;
        this.initializeTaskAttributes();
        PMController.logInfoMessage("[PEAR Merger]: task parameters =>");
        PMController.logInfoMessage("> Input PEARs =>");
        for (int i = 0; i < this._inpPearFiles.length; ++i) {
            PMController.logInfoMessage(">> " + this._inpPearFiles[i].getAbsolutePath());
        }
        PMController.logInfoMessage("> Output PEAR =>");
        PMController.logInfoMessage(">> Name = " + this._outAggCompName);
        PMController.logInfoMessage(">> File = " + this._outAggPearFile.getAbsolutePath());
        PMController.logInfoMessage("> Output root dir: " + this._outAggRootDir.getAbsolutePath());
    }

    public void cleanUp() throws IOException {
        PMController.logInfoMessage("[PEAR Merger]: deleting temporary files");
        FileUtil.deleteDirectory(this._outAggRootDir);
    }

    private long extractInputPears() throws IOException {
        long totalSize = 0L;
        for (int i = 0; i < this._inpPearFiles.length; ++i) {
            JarFile pearFile = new JarFile(this._inpPearFiles[i]);
            totalSize += FileUtil.extractFilesFromJar(pearFile, this._outDlgRootDirs[i]);
        }
        return totalSize;
    }

    private void initializeTaskAttributes() throws IOException {
        if (this._outAggPearFile == null) {
            this._outAggPearFile = new File(this._outAggCompName + ".pear");
        }
        String userHomePath = System.getProperty("user.home");
        this._tempWorkDir = new File(userHomePath);
        if (!this._tempWorkDir.isDirectory()) {
            throw new IOException(userHomePath + " directory not found");
        }
        this._outAggRootDir = new File(this._tempWorkDir, this._outAggCompName);
        if (this._outAggRootDir.isDirectory()) {
            if (!FileUtil.deleteDirectory(this._outAggRootDir)) {
                throw new IOException("cannot delete existing folder " + this._outAggRootDir.getAbsolutePath());
            }
        } else if (this._outAggRootDir.isFile() && !this._outAggRootDir.delete()) {
            throw new IOException("cannot delete existing file " + this._outAggRootDir.getAbsolutePath());
        }
        this._outDlgRootDirs = new File[this._inpPearFiles.length];
        for (int i = 0; i < this._outDlgRootDirs.length; ++i) {
            String fileName = this._inpPearFiles[i].getName();
            String sdirName = fileName.substring(0, fileName.lastIndexOf(46));
            this._outDlgRootDirs[i] = new File(this._outAggRootDir, sdirName);
        }
        this._dlgInstDescs = new InstallationDescriptor[this._inpPearFiles.length];
    }

    public boolean mergePears() throws IOException {
        boolean done = false;
        PMController.logInfoMessage("[PEAR Merger]: extracting delegate PEARs ...");
        long totalSize = this.extractInputPears();
        PMController.logInfoMessage("[PEAR Merger]: " + totalSize + " bytes extracted successfully");
        for (int i = 0; i < this._outDlgRootDirs.length; ++i) {
            this._dlgInstDescs[i] = PMControllerHelper.processDescriptors(this._outDlgRootDirs[i]);
            if (this._dlgInstDescs[i] != null) continue;
            PMController.logErrorMessage("[PEAR Merger]: failed to process input package in " + this._outDlgRootDirs[i] + "directory");
            break;
        }
        File pkgDescDir = new File(this._outAggRootDir, PackageBrowser.DESCRIPTORS_DIR);
        File pkgMetadataDir = new File(this._outAggRootDir, PackageBrowser.METADATA_DIR);
        if (!pkgDescDir.mkdirs() || !pkgMetadataDir.mkdirs()) {
            throw new IOException("cannot create merged package folders");
        }
        PMController.logInfoMessage("[PEAR Merger]: created merged package directory structure");
        File aggDescFile = new File(pkgDescDir, this._outAggCompName + ".xml");
        AnalysisEngineDescription aggDescription = PMUimaAgent.createAggregateDescription(this._outAggCompName, this._outAggRootDir, this._dlgInstDescs);
        if (aggDescription != null) {
            PMUimaAgent.saveAggregateDescription(aggDescription, aggDescFile);
            PMController.logInfoMessage("[PEAR Merger]: generated aggregate component descriptor");
            if (System.getProperty("DEBUG") != null) {
                PMController.logInfoMessage(PMUimaAgent.toXmlString(aggDescription));
            }
        } else {
            throw new IOException("cannot generate aggregate component descriptor");
        }
        this._outAggInstDesc = PMControllerHelper.generateMergedInstallationDescriptor(this._outAggRootDir, this._outAggCompName, aggDescFile, this._dlgInstDescs, this._outDlgRootDirs);
        if (this._outAggInstDesc != null) {
            PMController.logInfoMessage("[PEAR Merger]: generated aggregate package installation descriptor");
            if (System.getProperty("DEBUG") != null) {
                PMController.logInfoMessage(this._outAggInstDesc.toString());
            }
            File outPearFile = FileUtil.zipDirectory(this._outAggRootDir, this._outAggPearFile);
            PMController.logInfoMessage("[PEAR Merger]: created output aggregate PEAR file - " + outPearFile.getAbsolutePath());
            done = true;
        }
        return done;
    }

    static {
        __logger = Logger.getLogger(PMController.class.getName());
        __logger.setUseParentHandlers(false);
    }

    static class PMLogFormatter
    extends SimpleFormatter {
        private boolean _firstTime = true;

        PMLogFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            if (this._firstTime) {
                this._firstTime = false;
                record.setSourceMethodName("");
                return super.format(record);
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(record.getLevel());
            String message = record.getMessage();
            if (message.indexOf(10) >= 0) {
                buffer.append(": \n");
            } else {
                buffer.append(": ");
            }
            buffer.append(record.getMessage());
            buffer.append('\n');
            return buffer.toString();
        }
    }
}

