/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.pear.install;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.util.MessageRouter;
import org.apache.uima.pear.util.UIMAUtil;
import org.apache.uima.tools.cvd.CVD;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.util.gui.AboutDialog;

public class InstallPear
extends JFrame {
    private static final long serialVersionUID = -450696952085640703L;
    private JTextField pearFileTextField = null;
    private JButton browseButton = null;
    private static JTextField installDirTextField = null;
    private JButton browseDirButton = null;
    private JButton installButton = null;
    private JMenuBar menuBar = null;
    private JMenuItem fileMenuItem = null;
    private JMenuItem helpMenuItem = null;
    private JMenuItem aboutMenuItem = null;
    private JMenu fileMenu = null;
    private JMenu helpMenu = null;
    private static JButton runButton = null;
    private JButton helpButton = null;
    private static JTextArea pearConsole = null;
    private static JScrollPane jScrollPane = null;
    private static File localTearFile = null;
    private static File installationDir = null;
    private static String mainComponentId;
    private static InstallationDescriptor insdObject;
    private static String mainComponentRootPath;
    private static boolean helpExists;
    private static String message;
    private static boolean errorFlag;
    private static Preferences userPrefs;
    private static final String LAST_FILE_NAME_CHOOSEN_KEY = "LAST_FILE_NAME_CHOOSEN";
    private static final String LAST_DIRECTORY_CHOOSEN_KEY = "LAST_DIRECTORY_CHOOSEN";
    private static final String SET_ENV_FILE = "metadata/setenv.txt";

    private String selectPear() {
        userPrefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        String selectedFileName = null;
        fileChooser.addChoosableFileFilter(new PEARFilter());
        String lastFileName = this.pearFileTextField.getText().length() > 0 ? this.pearFileTextField.getText() : userPrefs.get(LAST_FILE_NAME_CHOOSEN_KEY, "./");
        File directory = lastFileName.length() > 0 ? new File(lastFileName).getParentFile() : new File("./");
        fileChooser.setCurrentDirectory(directory);
        fileChooser.setFileSelectionMode(0);
        int result = fileChooser.showDialog(new JFrame(), "Select");
        if (result == 0) {
            selectedFileName = fileChooser.getSelectedFile().getAbsolutePath();
            this.pearFileTextField.setText(selectedFileName);
            this.installButton.setEnabled(true);
            try {
                userPrefs.put(LAST_FILE_NAME_CHOOSEN_KEY, selectedFileName);
            }
            catch (NullPointerException ex) {
                pearConsole.append("NullPointerException" + ex);
            }
        } else if (result == 1) {
            if (this.pearFileTextField != null) {
                this.installButton.setEnabled(false);
            }
            this.pearFileTextField.setText("");
            pearConsole.setText("Operation Cancelled! \n");
            return null;
        }
        return selectedFileName;
    }

    private String selectDir() {
        userPrefs = Preferences.userNodeForPackage(this.getClass());
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new PEARFilter());
        String lastDirName = installDirTextField.getText().length() > 0 ? installDirTextField.getText() : userPrefs.get(LAST_DIRECTORY_CHOOSEN_KEY, "./");
        String selectedDirName = null;
        File directory = lastDirName.length() > 0 ? new File(lastDirName).getParentFile() : new File("./");
        fileChooser.setCurrentDirectory(directory);
        fileChooser.setFileSelectionMode(1);
        int result = fileChooser.showDialog(new JFrame(), "Select");
        if (result == 0) {
            selectedDirName = fileChooser.getSelectedFile().getAbsolutePath();
            try {
                userPrefs.put(LAST_DIRECTORY_CHOOSEN_KEY, selectedDirName);
            }
            catch (NullPointerException ex) {
                pearConsole.append("NullPointerException" + ex);
            }
            installDirTextField.setText(selectedDirName);
            this.installButton.setEnabled(true);
        } else {
            this.installButton.setEnabled(true);
        }
        return selectedDirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installPear(File localPearFile, File installationDir) {
        block19: {
            InstallationController.setLocalMode(true);
            InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
            pearConsole.setText("");
            InstallPear.printInConsole(false, "");
            if (localPearFile != null && !localPearFile.exists()) {
                errorFlag = true;
                message = localPearFile.getAbsolutePath() + "file not found \n";
                InstallPear.printInConsole(errorFlag, message);
            } else if (localPearFile != null) {
                pearConsole.append("PEAR file to install is => " + localPearFile.getAbsolutePath() + "\n");
            }
            if (installationDir == null) {
                installationDir = new File("./");
            }
            pearConsole.append("Installation directory is => " + installationDir.getAbsolutePath() + "\n");
            try {
                JarFile jarFile = new JarFile(localPearFile);
                installationDescriptorHandler.parseInstallationDescriptor(jarFile);
                insdObject = installationDescriptorHandler.getInstallationDescriptor();
                if (insdObject == null) {
                    pearConsole.setForeground(new Color(0xFF0000));
                    throw new FileNotFoundException("installation descriptor not found \n");
                }
                mainComponentId = insdObject.getMainComponentId();
                if (insdObject.getDelegateComponents().size() > 0) {
                    throw new RuntimeException("separate delegate components not supported \n");
                }
            }
            catch (Exception err) {
                errorFlag = true;
                message = " terminated \n" + err.toString();
                InstallPear.printInConsole(errorFlag, message);
                return;
            }
            InstallationController installationController = new InstallationController(mainComponentId, localPearFile, installationDir);
            installationController.addMsgListener(new MessageRouter.StdChannelListener(){

                @Override
                public void errMsgPosted(String errMsg) {
                    InstallPear.printInConsole(true, errMsg);
                }

                @Override
                public void outMsgPosted(String outMsg) {
                    InstallPear.printInConsole(false, outMsg);
                }
            });
            insdObject = installationController.installComponent();
            if (insdObject == null) {
                runButton.setEnabled(false);
                errorFlag = true;
                message = " \nInstallation of " + mainComponentId + " failed => \n " + installationController.getInstallationMsg();
                InstallPear.printInConsole(errorFlag, message);
            } else {
                try {
                    installationController.saveInstallationDescriptorFile();
                    mainComponentRootPath = insdObject.getMainComponentRoot();
                    errorFlag = false;
                    message = " \nInstallation of " + mainComponentId + " completed \n";
                    InstallPear.printInConsole(errorFlag, message);
                    message = "The " + mainComponentRootPath + "/" + SET_ENV_FILE + " \n    file contains required environment variables for this component\n";
                    InstallPear.printInConsole(errorFlag, message);
                    if (installationController.verifyComponent()) {
                        File xmlDescFile = new File(insdObject.getMainComponentDesc());
                        try {
                            String uimaCompCtg = UIMAUtil.identifyUimaComponentCategory(xmlDescFile);
                            if ("AE".equals(uimaCompCtg)) {
                                runButton.setEnabled(true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        errorFlag = false;
                        message = "Verification of " + mainComponentId + " completed \n";
                        InstallPear.printInConsole(errorFlag, message);
                        break block19;
                    }
                    runButton.setEnabled(false);
                    errorFlag = true;
                    message = "Verification of " + mainComponentId + " failed => \n " + installationController.getVerificationMsg();
                    InstallPear.printInConsole(errorFlag, message);
                }
                catch (Exception exc) {
                    errorFlag = true;
                    message = "Error in InstallationController.main(): " + exc.toString();
                    InstallPear.printInConsole(errorFlag, message);
                }
                finally {
                    installationController.terminate();
                }
            }
        }
    }

    private void runCVD() {
        Runnable runCVD = new Runnable(){

            @Override
            public void run() {
                try {
                    PackageBrowser pkgBrowser = new PackageBrowser(new File(mainComponentRootPath));
                    String pearDesc = pkgBrowser.getComponentPearDescPath();
                    MainFrame frame = CVD.createMainFrame();
                    frame.setExitOnClose(false);
                    frame.loadAEDescriptor(new File(pearDesc));
                    frame.runAE(true);
                }
                catch (Throwable e) {
                    pearConsole.append(" Error in runCVD() " + e.toString());
                    StringWriter strWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter((Writer)strWriter, true);
                    e.printStackTrace(printWriter);
                    printWriter.flush();
                    strWriter.flush();
                    pearConsole.setForeground(new Color(0xFF0000));
                    pearConsole.append(strWriter.toString());
                }
            }
        };
        Thread th = new Thread(runCVD);
        th.start();
    }

    private JTextField getPearFileTextField() {
        if (this.pearFileTextField == null) {
            this.pearFileTextField = new JTextField();
            this.pearFileTextField.setBounds(83, 40, 492, 20);
            this.pearFileTextField.setLayout(new BorderLayout());
            this.pearFileTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof JTextField) {
                        InstallPear.this.pearFileTextField = (JTextField)e.getSource();
                        InstallPear.this.installButton.setEnabled(true);
                        runButton.setEnabled(false);
                        if (InstallPear.this.pearFileTextField != null) {
                            pearConsole.setText("");
                            InstallPear.printInConsole(false, "");
                            pearConsole.append(InstallPear.this.pearFileTextField.getText() + "\n");
                        }
                    }
                }
            });
            this.pearFileTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    runButton.setEnabled(false);
                    String inputPear = InstallPear.this.pearFileTextField.getText();
                    if (inputPear.length() > 0) {
                        InstallPear.this.installButton.setEnabled(true);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    runButton.setEnabled(false);
                    String inputPear = InstallPear.this.pearFileTextField.getText();
                    if (inputPear.length() == 0) {
                        InstallPear.this.installButton.setEnabled(false);
                    }
                }
            });
        }
        return this.pearFileTextField;
    }

    private JButton getbrowseButton() {
        if (this.browseButton == null) {
            this.browseButton = new JButton();
            this.browseButton.setBounds(579, 40, 114, 20);
            this.browseButton.setText("Browse...");
            this.browseButton.setCursor(new Cursor(12));
            this.browseButton.setMnemonic('b');
            this.browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String pear = null;
                    if (e.getActionCommand().equals("Browse...")) {
                        runButton.setEnabled(false);
                        pear = InstallPear.this.selectPear();
                        if (pear == null) {
                            return;
                        }
                    }
                }
            });
        }
        return this.browseButton;
    }

    private JTextField getInstallDirTextField() {
        if (installDirTextField == null) {
            installDirTextField = new JTextField();
            installDirTextField.setBounds(83, 80, 492, 20);
            installDirTextField.isEditable();
            installDirTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof JTextField) {
                        runButton.setEnabled(false);
                        installDirTextField = (JTextField)e.getSource();
                        if (installDirTextField != null) {
                            pearConsole.append(installDirTextField.getText() + "\n");
                        }
                    }
                }
            });
            installDirTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    runButton.setEnabled(false);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    runButton.setEnabled(false);
                }
            });
        }
        return installDirTextField;
    }

    private JButton getBrowseDirButton() {
        if (this.browseDirButton == null) {
            this.browseDirButton = new JButton();
            this.browseDirButton.setBounds(579, 80, 114, 20);
            this.browseDirButton.setText("Browse Dir...");
            this.browseDirButton.setEnabled(false);
            this.browseDirButton.setCursor(new Cursor(12));
            this.browseDirButton.setMnemonic('d');
            this.browseDirButton.setEnabled(true);
            this.browseDirButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String dir2 = null;
                    File installationDir = null;
                    runButton.setEnabled(false);
                    if (e.getActionCommand().equals("Browse Dir...")) {
                        dir2 = InstallPear.this.selectDir();
                        if (dir2 == null) {
                            installationDir = new File("./");
                            installDirTextField.setText(installationDir.getAbsolutePath());
                        } else {
                            installDirTextField.setText(dir2);
                        }
                    }
                }
            });
        }
        return this.browseDirButton;
    }

    private JButton getInstallButton() {
        if (this.installButton == null) {
            this.installButton = new JButton();
            this.installButton.setBounds(100, 120, 108, 24);
            this.installButton.setText("Install");
            this.installButton.setEnabled(false);
            this.installButton.setCursor(new Cursor(12));
            this.installButton.setMnemonic('i');
            this.installButton.setRolloverEnabled(true);
            this.installButton.addActionListener(new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("Install")) {
                        localTearFile = new File(InstallPear.this.pearFileTextField.getText());
                        installationDir = new File(installDirTextField.getText());
                        RunInstallation installPear = new RunInstallation(localTearFile, installationDir);
                        Thread thread = new Thread(installPear);
                        thread.start();
                        InstallPear.this.installButton.setCursor(new Cursor(3));
                        RunInstallation runInstallation = installPear;
                        synchronized (runInstallation) {
                            try {
                                installPear.wait(500000L);
                            }
                            catch (InterruptedException ex) {
                                errorFlag = true;
                                message = "InterruptedException " + ex;
                                InstallPear.printInConsole(errorFlag, message);
                            }
                        }
                        InstallPear.this.installButton.setCursor(new Cursor(0));
                    }
                }
            });
        }
        return this.installButton;
    }

    private JButton getRunButton() {
        if (runButton == null) {
            runButton = new JButton();
            runButton.setBounds(255, 120, 240, 24);
            runButton.setText("Run your AE in the CAS Visual Debugger");
            runButton.setEnabled(false);
            runButton.setCursor(new Cursor(12));
            runButton.setMnemonic('r');
            runButton.setRolloverEnabled(true);
            runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("Run your AE in the CAS Visual Debugger")) {
                        InstallPear.this.installButton.setEnabled(false);
                        InstallPear.this.runCVD();
                    }
                }
            });
        }
        return runButton;
    }

    private JTextArea getPearConsole() {
        if (pearConsole == null) {
            pearConsole = new JTextArea();
            pearConsole.setEditable(false);
            pearConsole.setForeground(new Color(26367));
            pearConsole.setLineWrap(true);
            pearConsole.setWrapStyleWord(true);
        }
        return pearConsole;
    }

    private static void printInConsole(boolean errorFlag, String message) {
        if (errorFlag) {
            pearConsole.setForeground(new Color(0xFF0000));
            pearConsole.setText(message);
        } else {
            pearConsole.setForeground(new Color(26367));
            pearConsole.append(message);
        }
    }

    private JScrollPane getJScrollPane() {
        if (jScrollPane == null) {
            jScrollPane = new JScrollPane(this.getPearConsole(), 22, 32);
            jScrollPane.setBounds(10, 150, 708, 352);
            jScrollPane.setHorizontalScrollBarPolicy(32);
            jScrollPane.setVerticalScrollBarPolicy(22);
        }
        return jScrollPane;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setBounds(540, 120, 108, 24);
            this.helpButton.setText("Help");
            this.helpButton.setEnabled(helpExists);
            this.helpButton.setCursor(new Cursor(12));
            this.helpButton.setMnemonic('h');
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand() == "Help") {
                        try {
                            URL helpFileUrl = this.getClass().getResource("piHelp.html");
                            if (helpFileUrl == null) {
                                String msg = "PEAR Installer help file does not exist.";
                                JOptionPane.showMessageDialog(InstallPear.this, msg, "Error showing help", 0);
                                return;
                            }
                            JFrame manFrame = new JFrame("PEAR Installer Help");
                            JEditorPane editorPane = new JEditorPane();
                            editorPane.setEditable(false);
                            editorPane.setPage(helpFileUrl);
                            JScrollPane scrollPane = new JScrollPane(editorPane);
                            scrollPane.setPreferredSize(new Dimension(700, 800));
                            manFrame.setContentPane(scrollPane);
                            manFrame.pack();
                            manFrame.setVisible(true);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(InstallPear.this, ex.getMessage(), "Error showing help", 0);
                        }
                    }
                }
            });
        }
        return this.helpButton;
    }

    private static void createAndShowGUI() {
        InstallPear installPear = new InstallPear();
        installPear.setDefaultCloseOperation(3);
        installPear.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InstallPear.createAndShowGUI();
            }
        });
    }

    public InstallPear() {
        this.initialize();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Could not set look and feel: " + exception.getMessage());
        }
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("/org/apache/uima/tools/images/Micro_16.gif")));
        }
        catch (IOException ioexception) {
            System.err.println("Image could not be loaded: " + ioexception.getMessage());
        }
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('f');
        this.fileMenuItem = new JMenuItem("Exit");
        this.fileMenuItem.setMnemonic('e');
        this.menuBar.add(this.fileMenu);
        this.fileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.fileMenu.add(this.fileMenuItem);
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('h');
        this.aboutMenuItem = new JMenuItem("About");
        this.aboutMenuItem.setMnemonic('a');
        this.helpMenuItem = new JMenuItem("Help");
        this.helpMenuItem.setMnemonic('h');
        this.menuBar.add(this.helpMenu);
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "Help") {
                    try {
                        URL helpFileUrl = this.getClass().getResource("piHelp.html");
                        if (helpFileUrl == null) {
                            String msg = "PEAR Installer help file does not exist.";
                            JOptionPane.showMessageDialog(InstallPear.this, msg, "Error showing help", 0);
                            return;
                        }
                        JFrame manFrame = new JFrame("PEAR Installer Help");
                        JEditorPane editorPane = new JEditorPane();
                        editorPane.setEditable(false);
                        editorPane.setPage(helpFileUrl);
                        JScrollPane scrollPane = new JScrollPane(editorPane);
                        scrollPane.setPreferredSize(new Dimension(700, 800));
                        manFrame.setContentPane(scrollPane);
                        manFrame.pack();
                        manFrame.setVisible(true);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(InstallPear.this, ex.getMessage(), "Error showing help", 0);
                    }
                }
            }
        });
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand() == "About") {
                    AboutDialog dialog = new AboutDialog(InstallPear.this, "About PEAR Installer");
                    dialog.setVisible(true);
                }
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.aboutMenuItem);
        JLabel installDirLabel = new JLabel();
        JLabel pearFileLabel = new JLabel();
        JPanel mainPane = new JPanel();
        mainPane.setLayout(null);
        pearFileLabel.setBounds(83, 20, 126, 20);
        pearFileLabel.setText("PEAR File:");
        installDirLabel.setBounds(83, 60, 126, 20);
        installDirLabel.setText("Installation Directory:");
        mainPane.add((Component)pearFileLabel, null);
        mainPane.add((Component)this.getPearFileTextField(), null);
        mainPane.add((Component)this.getbrowseButton(), null);
        mainPane.add((Component)installDirLabel, null);
        mainPane.add((Component)this.getInstallDirTextField(), null);
        mainPane.add((Component)this.getBrowseDirButton(), null);
        mainPane.add((Component)this.getInstallButton(), null);
        mainPane.add((Component)this.getRunButton(), null);
        mainPane.add((Component)this.getHelpButton(), null);
        mainPane.add((Component)this.getPearConsole(), null);
        mainPane.add((Component)this.getJScrollPane(), null);
        Container contentPanel = this.getContentPane();
        contentPanel.setBackground(Color.WHITE);
        JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner2tlp.png"));
        contentPanel.add((Component)banner, "North");
        contentPanel.add((Component)mainPane, "Center");
    }

    private void initialize() {
        this.setTitle("Local PEAR Installation, Verification and Testing");
        this.setSize(735, 620);
        this.setResizable(false);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension GUISize = this.getSize();
        int centerPosX = (screenSize.width - GUISize.width) / 2;
        int centerPosY = (screenSize.width - GUISize.width) / 2;
        this.setLocation(centerPosX, centerPosY);
    }

    static {
        helpExists = true;
        message = null;
        errorFlag = false;
    }

    protected static class PEARFilter
    extends FileFilter {
        static final String TEAR_EXT = "tear";
        static final String PEAR_EXT = "pear";

        protected PEARFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(file);
            return extension.equals(TEAR_EXT) || extension.equals(PEAR_EXT);
        }

        private String getExtension(File f) {
            String s2 = f.getName();
            int i = s2.lastIndexOf(46);
            if (i > 0 && i < s2.length() - 1) {
                return s2.substring(i + 1).toLowerCase();
            }
            return "";
        }

        @Override
        public String getDescription() {
            return "PEAR files";
        }
    }

    protected static class RunInstallation
    implements Runnable {
        private File pearFile;
        private File installationDir = null;

        public RunInstallation(File pearFile, File installationDir) {
            this.pearFile = pearFile;
            this.installationDir = installationDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InstallPear.installPear(this.pearFile, this.installationDir);
            RunInstallation runInstallation = this;
            synchronized (runInstallation) {
                this.notifyAll();
            }
        }
    }
}

