/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.type.Statistics;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;
import org.apache.uima.ruta.visitor.RutaInferenceVisitor;

public class StatisticsVisitor
implements RutaInferenceVisitor {
    private Map<String, Long> conditionTime;
    private Map<String, Long> actionTime;
    private Map<String, Integer> conditionAmount;
    private Map<String, Integer> actionAmount;
    private Map<String, Long> conditionDelta;
    private Map<String, Long> actionDelta;
    private RutaVerbalizer verbalizer;

    public StatisticsVisitor(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
        this.conditionTime = new HashMap<String, Long>();
        this.actionTime = new HashMap<String, Long>();
        this.conditionAmount = new HashMap<String, Integer>();
        this.actionAmount = new HashMap<String, Integer>();
        this.conditionDelta = new HashMap<String, Long>();
        this.actionDelta = new HashMap<String, Long>();
    }

    @Override
    public void beginVisit(RutaElement element, ScriptApply result) {
        if (element instanceof AbstractRutaCondition) {
            AbstractRutaCondition c = (AbstractRutaCondition)element;
            String name = this.verbalizer.verbalizeName(c);
            Integer amount = this.conditionAmount.get(name);
            if (amount == null) {
                amount = 0;
            }
            Integer n = amount;
            Integer n2 = amount = Integer.valueOf(amount + 1);
            this.conditionAmount.put(name, amount);
            this.conditionDelta.put(name, System.currentTimeMillis());
        } else if (element instanceof AbstractRutaAction) {
            AbstractRutaAction a = (AbstractRutaAction)element;
            String name = this.verbalizer.verbalizeName(a);
            Integer amount = this.actionAmount.get(name);
            if (amount == null) {
                amount = 0;
            }
            Integer n = amount;
            Integer n3 = amount = Integer.valueOf(amount + 1);
            this.actionAmount.put(name, amount);
            this.actionDelta.put(name, System.currentTimeMillis());
        }
    }

    @Override
    public void endVisit(RutaElement element, ScriptApply result) {
        if (element instanceof AbstractRutaCondition) {
            AbstractRutaCondition c = (AbstractRutaCondition)element;
            String name = this.verbalizer.verbalizeName(c);
            Long start = this.conditionDelta.get(name);
            long delta = System.currentTimeMillis() - start;
            Long total = this.conditionTime.get(name);
            if (total == null) {
                total = 0L;
            }
            total = total + delta;
            this.conditionTime.put(name, total);
        } else if (element instanceof AbstractRutaAction) {
            AbstractRutaAction a = (AbstractRutaAction)element;
            String name = this.verbalizer.verbalizeName(a);
            Long start = this.actionDelta.get(name);
            long delta = System.currentTimeMillis() - start;
            Long total = this.actionTime.get(name);
            if (total == null) {
                total = 0L;
            }
            total = total + delta;
            this.actionTime.put(name, total);
        }
    }

    @Override
    public void finished(RutaStream stream, List<RutaInferenceVisitor> visitors) {
        double part;
        double amount;
        double total;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> totals = new ArrayList<Double>();
        ArrayList<Integer> amounts = new ArrayList<Integer>();
        ArrayList<Double> parts = new ArrayList<Double>();
        for (String each : this.conditionTime.keySet()) {
            total = this.conditionTime.get(each).longValue();
            amount = this.conditionAmount.get(each).intValue();
            part = total / amount;
            part *= 10000.0;
            part = Math.round(part);
            part /= 10000.0;
            names.add(each);
            totals.add(total);
            amounts.add((int)amount);
            parts.add(part);
        }
        for (String each : this.actionTime.keySet()) {
            total = this.actionTime.get(each).longValue();
            amount = this.actionAmount.get(each).intValue();
            part = total / amount;
            part *= 10000.0;
            part = Math.round(part);
            part /= 10000.0;
            names.add(each);
            totals.add(total);
            amounts.add((int)amount);
            parts.add(part);
        }
        JCas jCas = stream.getJCas();
        StringArray nameArray = UIMAUtils.toStringArray(jCas, names.toArray(new String[0]));
        DoubleArray totalArray = UIMAUtils.toDoubleArray(jCas, this.getDoubleArray(totals));
        IntegerArray amountArray = UIMAUtils.toIntegerArray(jCas, this.getIntegerArray(amounts));
        DoubleArray partArray = UIMAUtils.toDoubleArray(jCas, this.getDoubleArray(parts));
        Type type = jCas.getCasType(Statistics.type);
        Feature fname = type.getFeatureByBaseName("name");
        Feature ftotal = type.getFeatureByBaseName("total");
        Feature famount = type.getFeatureByBaseName("amount");
        Feature fparts = type.getFeatureByBaseName("part");
        Object fs = jCas.getCas().createFS(type);
        fs.setFeatureValue(fname, nameArray);
        fs.setFeatureValue(ftotal, totalArray);
        fs.setFeatureValue(famount, amountArray);
        fs.setFeatureValue(fparts, partArray);
        jCas.getCas().addFsToIndexes((FeatureStructure)fs);
    }

    private int[] getIntegerArray(List<Integer> array) {
        int[] result = new int[array.size()];
        int i = 0;
        for (Integer each : array) {
            result[i++] = each;
        }
        return result;
    }

    private double[] getDoubleArray(List<Double> array) {
        double[] result = new double[array.size()];
        int i = 0;
        for (Double each : array) {
            result[i++] = each;
        }
        return result;
    }

    public Map<String, Long> getConditionTime() {
        return this.conditionTime;
    }

    public Map<String, Long> getActionTime() {
        return this.actionTime;
    }

    public Map<String, Integer> getConditionAmount() {
        return this.conditionAmount;
    }

    public Map<String, Integer> getActionAmount() {
        return this.actionAmount;
    }

    @Override
    public void annotationAdded(AnnotationFS annotation, AbstractRuleMatch<? extends AbstractRule> creator) {
    }
}

