/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.FSCollectionFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.block.BlockApply;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RegExpRule;
import org.apache.uima.ruta.rule.RegExpRuleMatch;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.type.DebugBlockApply;
import org.apache.uima.ruta.type.DebugEvaluatedCondition;
import org.apache.uima.ruta.type.DebugFailedRuleMatch;
import org.apache.uima.ruta.type.DebugInlinedBlock;
import org.apache.uima.ruta.type.DebugMatchedRuleMatch;
import org.apache.uima.ruta.type.DebugRuleApply;
import org.apache.uima.ruta.type.DebugRuleElementMatch;
import org.apache.uima.ruta.type.DebugRuleElementMatches;
import org.apache.uima.ruta.type.DebugRuleMatch;
import org.apache.uima.ruta.type.DebugScriptApply;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class DebugInfoFactory {
    private RutaVerbalizer verbalizer;

    public DebugInfoFactory(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public DebugBlockApply createDummyBlockApply(RuleMatch ruleMatch, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        JCas cas = stream.getJCas();
        DebugBlockApply dba = new DebugBlockApply(cas);
        AnnotationFS matchedAnnotation = ruleMatch.getMatchedAnnotationsOfElement(((RutaRule)ruleMatch.getRule()).getRoot()).get(0);
        dba.setElement(matchedAnnotation.getCoveredText());
        dba.setBegin(matchedAnnotation.getBegin());
        dba.setEnd(matchedAnnotation.getEnd());
        return dba;
    }

    public DebugBlockApply createDebugBlockApply(BlockApply blockApply, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        Long time;
        JCas cas = stream.getJCas();
        DebugBlockApply dba = new DebugBlockApply(cas);
        ArrayList<DebugScriptApply> innerApply = new ArrayList<DebugScriptApply>();
        int applied = blockApply.getRuleApply().getApplied();
        RutaElement element = blockApply.getElement();
        String verbalize = "";
        verbalize = this.verbalizer.verbalize(element);
        if (applied > 1) {
            List<ScriptApply> innerApplies = blockApply.getInnerApplies();
            ArrayList loops = new ArrayList();
            for (int i = 0; i < applied; ++i) {
                loops.add(new ArrayList());
            }
            int counter = 0;
            int size = innerApplies.size();
            int parts = size / applied;
            for (ScriptApply scriptApply : innerApplies) {
                int listIndex = Math.max(0, counter / parts);
                List list = (List)loops.get(listIndex);
                list.add(scriptApply);
                ++counter;
            }
            counter = 0;
            for (List list : loops) {
                AbstractRuleMatch<? extends AbstractRule> ruleMatch = blockApply.getRuleApply().getList().get(counter);
                DebugBlockApply dummyBlockApply = this.createDummyBlockApply((RuleMatch)ruleMatch, stream, addToIndex, withMatches, timeInfo);
                ArrayList<DebugRuleMatch> ruleMatches = new ArrayList<DebugRuleMatch>();
                ruleMatches.add(this.createDebugRuleMatch(ruleMatch, stream, addToIndex, withMatches, timeInfo));
                dummyBlockApply.setApplied(1);
                dummyBlockApply.setTried(1);
                dummyBlockApply.setRules(UIMAUtils.toFSArray(cas, ruleMatches));
                ArrayList<DebugScriptApply> innerInnerApply = new ArrayList<DebugScriptApply>();
                for (ScriptApply each : list) {
                    DebugScriptApply eachInnerInner = this.createDebugScriptApply(each, stream, addToIndex, withMatches, timeInfo);
                    innerInnerApply.add(eachInnerInner);
                }
                dummyBlockApply.setInnerApply(UIMAUtils.toFSArray(cas, innerInnerApply));
                innerApply.add(dummyBlockApply);
                ++counter;
            }
            dba.setInnerApply(UIMAUtils.toFSArray(cas, innerApply));
            dba.setElement(verbalize);
            DebugRuleApply ruleApply = this.createDebugRuleApply(blockApply.getRuleApply(), stream, addToIndex, withMatches, timeInfo);
            dba.setApplied(ruleApply.getApplied());
            dba.setTried(ruleApply.getTried());
            dba.setRules(ruleApply.getRules());
            dba.setBegin(ruleApply.getBegin());
            dba.setEnd(ruleApply.getEnd());
            if (timeInfo != null) {
                long l = timeInfo.get(element);
                dba.setTime(l);
            }
            if (addToIndex) {
                dba.addToIndexes();
            }
            return dba;
        }
        for (ScriptApply each : blockApply.getInnerApplies()) {
            innerApply.add(this.createDebugScriptApply(each, stream, addToIndex, withMatches, timeInfo));
        }
        dba.setInnerApply(UIMAUtils.toFSArray(cas, innerApply));
        dba.setElement(verbalize);
        DebugRuleApply ruleApply = this.createDebugRuleApply(blockApply.getRuleApply(), stream, addToIndex, withMatches, timeInfo);
        dba.setApplied(ruleApply.getApplied());
        dba.setTried(ruleApply.getTried());
        dba.setRules(ruleApply.getRules());
        dba.setBegin(ruleApply.getBegin());
        dba.setEnd(ruleApply.getEnd());
        if (timeInfo != null && (time = timeInfo.get(element)) != null) {
            dba.setTime(time);
        }
        if (addToIndex) {
            dba.addToIndexes();
        }
        return dba;
    }

    public DebugRuleApply createDebugRuleApply(RuleApply ruleApply, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        Long time;
        JCas cas = stream.getJCas();
        DebugRuleApply dra = new DebugRuleApply(cas);
        ArrayList<DebugRuleMatch> ruleMatches = new ArrayList<DebugRuleMatch>();
        int begin = Integer.MAX_VALUE;
        int end = 0;
        if (withMatches) {
            for (AbstractRuleMatch<? extends AbstractRule> match : ruleApply.getList()) {
                DebugRuleMatch debugRuleMatch = this.createDebugRuleMatch(match, stream, addToIndex, withMatches, timeInfo);
                begin = Math.min(begin, debugRuleMatch.getBegin());
                end = Math.max(end, debugRuleMatch.getEnd());
                ruleMatches.add(debugRuleMatch);
            }
        }
        if (begin >= end) {
            begin = end;
        }
        dra.setRules(UIMAUtils.toFSArray(cas, ruleMatches));
        RutaElement element = ruleApply.getElement();
        String namespace = "";
        if (element instanceof RutaStatement) {
            RutaStatement rs = (RutaStatement)element;
            namespace = rs.getParent().getScript().getRootBlock().getNamespace();
        }
        dra.setElement(this.verbalizer.verbalize(element));
        dra.setApplied(ruleApply.getApplied());
        dra.setTried(ruleApply.getTried());
        dra.setId(((AbstractRule)element).getId());
        dra.setScript(namespace);
        dra.setBegin(begin);
        dra.setEnd(end);
        if (timeInfo != null && (time = timeInfo.get(element)) != null) {
            dra.setTime(time);
        }
        if (addToIndex) {
            dra.addToIndexes();
        }
        return dra;
    }

    public DebugRuleMatch createDebugRuleMatch(AbstractRuleMatch<? extends AbstractRule> match, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        AnnotationFS matchedAnnotation;
        List<AnnotationFS> matchedAnnotationsOfRoot;
        JCas cas = stream.getJCas();
        DebugRuleMatch drm = null;
        drm = match.matchedCompletely() ? new DebugMatchedRuleMatch(cas) : new DebugFailedRuleMatch(cas);
        drm.setMatched(match.matchedCompletely());
        if (match instanceof RuleMatch) {
            ComposedRuleElementMatch rootMatch = ((RuleMatch)match).getRootMatch();
            this.setInnerMatches(stream, addToIndex, withMatches, timeInfo, drm, rootMatch);
            ArrayList<DebugScriptApply> delegates = new ArrayList<DebugScriptApply>();
            for (ScriptApply rem : ((RuleMatch)match).getDelegateApply().values()) {
                delegates.add(this.createDebugScriptApply(rem, stream, addToIndex, withMatches, timeInfo));
            }
            drm.setDelegates(UIMAUtils.toFSArray(cas, delegates));
        } else if (match instanceof RegExpRuleMatch) {
            RegExpRuleMatch rerm = (RegExpRuleMatch)match;
            Map<Integer, List<AnnotationFS>> map = rerm.getMap();
            Set<Map.Entry<Integer, List<AnnotationFS>>> entrySet = map.entrySet();
            ArrayList<DebugRuleElementMatches> ruleElementMatches = new ArrayList<DebugRuleElementMatches>();
            for (Map.Entry<Integer, List<AnnotationFS>> entry : entrySet) {
                DebugRuleElementMatches drems = new DebugRuleElementMatches(cas);
                RegExpRule rule = (RegExpRule)rerm.getRule();
                Integer key = entry.getKey();
                List<AnnotationFS> value = entry.getValue();
                drems.setElement(this.verbalizer.verbalize(rule));
                ArrayList<DebugRuleElementMatch> remList = new ArrayList<DebugRuleElementMatch>();
                if (value != null) {
                    for (AnnotationFS each : value) {
                        DebugRuleElementMatch drem = new DebugRuleElementMatch(cas);
                        DebugEvaluatedCondition base = new DebugEvaluatedCondition(cas);
                        base.setValue(true);
                        String baseString = "Group " + key;
                        base.setElement(baseString);
                        drem.setBaseCondition(base);
                        if (each.getBegin() <= each.getEnd()) {
                            drem.setBegin(each.getBegin());
                            drem.setEnd(each.getEnd());
                        }
                        if (addToIndex) {
                            drem.addToIndexes();
                        }
                        remList.add(drem);
                    }
                }
                drems.setMatches(UIMAUtils.toFSArray(cas, remList));
                if (addToIndex) {
                    drems.addToIndexes();
                }
                ruleElementMatches.add(drems);
            }
            drm.setElements(UIMAUtils.toFSArray(cas, ruleElementMatches));
        }
        if (timeInfo != null) {
            long time = timeInfo.get(match.getRule());
            drm.setTime(time);
        }
        if (!(matchedAnnotationsOfRoot = match.getMatchedAnnotationsOfRoot()).isEmpty() && (matchedAnnotation = matchedAnnotationsOfRoot.get(0)) != null) {
            drm.setBegin(matchedAnnotation.getBegin());
            drm.setEnd(matchedAnnotation.getEnd());
            if (addToIndex || withMatches) {
                drm.addToIndexes();
            }
        }
        return drm;
    }

    private void setInnerMatches(RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo, DebugRuleMatch drm, ComposedRuleElementMatch rootMatch) {
        Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = rootMatch.getInnerMatches().entrySet();
        ArrayList<DebugRuleElementMatches> ruleElementMatches = new ArrayList<DebugRuleElementMatches>();
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
            RuleElement re = entry.getKey();
            List<RuleElementMatch> rems = entry.getValue();
            ruleElementMatches.add(this.createDebugRuleElementMatches(re, rems, stream, addToIndex, withMatches, timeInfo));
        }
        drm.setElements(UIMAUtils.toFSArray(stream.getJCas(), ruleElementMatches));
    }

    private void setInnerMatches(RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo, DebugRuleElementMatch drm, ComposedRuleElementMatch rootMatch) {
        Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = rootMatch.getInnerMatches().entrySet();
        ArrayList<DebugRuleElementMatches> ruleElementMatches = new ArrayList<DebugRuleElementMatches>();
        for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
            RuleElement re = entry.getKey();
            List<RuleElementMatch> rems = entry.getValue();
            ruleElementMatches.add(this.createDebugRuleElementMatches(re, rems, stream, addToIndex, withMatches, timeInfo));
        }
        drm.setElements(UIMAUtils.toFSArray(stream.getJCas(), ruleElementMatches));
    }

    public DebugRuleElementMatches createDebugRuleElementMatches(RuleElement re, List<RuleElementMatch> rems, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        JCas cas = stream.getJCas();
        DebugRuleElementMatches drems = new DebugRuleElementMatches(cas);
        drems.setElement(this.verbalizer.verbalize(re));
        ArrayList<DebugRuleElementMatch> remList = new ArrayList<DebugRuleElementMatch>();
        if (rems != null) {
            for (RuleElementMatch each : rems) {
                DebugRuleElementMatch rem = null;
                rem = each instanceof ComposedRuleElementMatch ? this.createDebugComposedRuleElementMatch((ComposedRuleElementMatch)each, stream, addToIndex, withMatches, timeInfo) : this.createDebugRuleElementMatch(each, stream, addToIndex);
                FSArray inlinedConditionBlocks = this.createInlinedBlocks(each.getInlinedConditionRules(), stream, true, addToIndex, withMatches, timeInfo);
                rem.setInlinedConditionBlocks(inlinedConditionBlocks);
                if (rem == null) continue;
                remList.add(rem);
            }
        }
        if (rems != null && !rems.isEmpty()) {
            drems.setRuleAnchor(rems.get(0).isRuleAnchor());
        }
        drems.setMatches(UIMAUtils.toFSArray(cas, remList));
        FSArray inlinedActionBlocks = this.createInlinedActionBlocks(rems, stream, addToIndex, withMatches, timeInfo);
        drems.setInlinedActionBlocks(inlinedActionBlocks);
        if (addToIndex) {
            drems.addToIndexes();
        }
        return drems;
    }

    private FSArray createInlinedBlocks(List<List<ScriptApply>> blocks, RutaStream stream, boolean asCondition, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        JCas jcas = stream.getJCas();
        if (blocks == null || blocks.isEmpty()) {
            return null;
        }
        ArrayList<DebugInlinedBlock> blockList = new ArrayList<DebugInlinedBlock>();
        for (List<ScriptApply> block : blocks) {
            ArrayList<DebugScriptApply> list = new ArrayList<DebugScriptApply>();
            boolean oneRuleApplied = false;
            for (ScriptApply ruleApply : block) {
                if (ruleApply instanceof RuleApply && ((RuleApply)ruleApply).getApplied() > 0) {
                    oneRuleApplied = true;
                }
                DebugScriptApply debugScriptApply = this.createDebugScriptApply(ruleApply, stream, addToIndex, withMatches, timeInfo);
                list.add(debugScriptApply);
            }
            DebugInlinedBlock debugInlinedBlock = new DebugInlinedBlock(jcas);
            debugInlinedBlock.setInlinedRules(FSCollectionFactory.createFSArray(jcas, list));
            debugInlinedBlock.setAsCondition(asCondition);
            if (asCondition) {
                debugInlinedBlock.setElement(this.verbalizer.verbalizeInlinedConditionRuleBlock(block));
                debugInlinedBlock.setMatched(oneRuleApplied);
            } else {
                debugInlinedBlock.setElement(this.verbalizer.verbalizeInlinedActionRuleBlock(block));
            }
            blockList.add(debugInlinedBlock);
        }
        return FSCollectionFactory.createFSArray(jcas, blockList);
    }

    private FSArray createInlinedActionBlocks(List<RuleElementMatch> rems, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        if (rems == null || rems.isEmpty()) {
            return null;
        }
        return this.createInlinedBlocks(rems.get(0).getInlinedActionRules(), stream, false, addToIndex, withMatches, timeInfo);
    }

    public DebugRuleElementMatch createDebugComposedRuleElementMatch(ComposedRuleElementMatch rem, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        int end;
        int begin;
        JCas cas = stream.getJCas();
        DebugRuleElementMatch drem = new DebugRuleElementMatch(cas);
        DebugEvaluatedCondition base = new DebugEvaluatedCondition(cas);
        base.setValue(rem.isBaseConditionMatched());
        this.setInnerMatches(stream, addToIndex, withMatches, timeInfo, drem, rem);
        String baseString = this.verbalizer.verbalize(rem.getRuleElement());
        base.setElement(baseString);
        drem.setBaseCondition(base);
        drem.setConditions(this.createEvaluatedConditions(rem, stream, addToIndex));
        List<AnnotationFS> annotations = rem.getTextsMatched();
        if (!annotations.isEmpty() && (begin = annotations.get(0).getBegin()) <= (end = annotations.get(annotations.size() - 1).getEnd())) {
            drem.setBegin(begin);
            drem.setEnd(end);
        }
        if (addToIndex) {
            drem.addToIndexes();
        }
        return drem;
    }

    public DebugRuleElementMatch createDebugRuleElementMatch(RuleElementMatch rem, RutaStream stream, boolean addToIndex) {
        int end;
        int begin;
        JCas cas = stream.getJCas();
        DebugRuleElementMatch drem = new DebugRuleElementMatch(cas);
        DebugEvaluatedCondition base = new DebugEvaluatedCondition(cas);
        base.setValue(rem.isBaseConditionMatched());
        RuleElement ruleElement = rem.getRuleElement();
        String baseString = "";
        if (ruleElement instanceof RutaRuleElement) {
            baseString = this.verbalizer.verbalizeMatcher((RutaRuleElement)ruleElement);
        } else if (ruleElement instanceof ComposedRuleElement) {
            baseString = this.verbalizer.verbalizeComposed((ComposedRuleElement)ruleElement);
        }
        base.setElement(baseString);
        drem.setBaseCondition(base);
        drem.setConditions(this.createEvaluatedConditions(rem, stream, addToIndex));
        List<AnnotationFS> annotations = rem.getTextsMatched();
        if (!annotations.isEmpty() && (begin = annotations.get(0).getBegin()) <= (end = annotations.get(annotations.size() - 1).getEnd())) {
            drem.setBegin(begin);
            drem.setEnd(end);
        }
        if (addToIndex) {
            drem.addToIndexes();
        }
        return drem;
    }

    private FSArray createEvaluatedConditions(RuleElementMatch rem, RutaStream stream, boolean addToIndex) {
        JCas cas = stream.getJCas();
        ArrayList<DebugEvaluatedCondition> ecs = new ArrayList<DebugEvaluatedCondition>();
        if (rem.getConditions() != null) {
            for (EvaluatedCondition each : rem.getConditions()) {
                DebugEvaluatedCondition ec = new DebugEvaluatedCondition(cas);
                ec.setValue(each.isValue());
                ec.setElement(this.verbalizer.verbalize(each.getCondition()));
                ec.setConditions(this.createEvaluatedConditions(each, stream, addToIndex));
                ecs.add(ec);
            }
        }
        FSArray result = UIMAUtils.toFSArray(cas, ecs);
        return result;
    }

    private FSArray createEvaluatedConditions(EvaluatedCondition eval, RutaStream stream, boolean addToIndex) {
        JCas cas = stream.getJCas();
        ArrayList<DebugEvaluatedCondition> ecs = new ArrayList<DebugEvaluatedCondition>();
        for (EvaluatedCondition each : eval.getConditions()) {
            DebugEvaluatedCondition ec = new DebugEvaluatedCondition(cas);
            ec.setValue(each.isValue());
            ec.setElement(this.verbalizer.verbalize(each.getCondition()));
            ec.setConditions(this.createEvaluatedConditions(each, stream, addToIndex));
            ecs.add(ec);
        }
        FSArray result = UIMAUtils.toFSArray(cas, ecs);
        return result;
    }

    public DebugScriptApply createDebugScriptApply(ScriptApply apply, RutaStream stream, boolean addToIndex, boolean withMatches, Map<RutaElement, Long> timeInfo) {
        TOP debug = null;
        if (apply instanceof BlockApply) {
            debug = this.createDebugBlockApply((BlockApply)apply, stream, addToIndex, withMatches, timeInfo);
        } else if (apply instanceof RuleApply) {
            debug = this.createDebugRuleApply((RuleApply)apply, stream, addToIndex, withMatches, timeInfo);
        }
        if (addToIndex) {
            debug.addToIndexes();
        }
        return debug;
    }
}

