/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.ForEachBlock;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ConjunctRulesRuleElement;
import org.apache.uima.ruta.rule.RegExpRule;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaOptionalRuleElement;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.WildCardRuleElement;
import org.apache.uima.ruta.rule.quantifier.MinMaxGreedy;
import org.apache.uima.ruta.rule.quantifier.MinMaxReluctant;
import org.apache.uima.ruta.rule.quantifier.NormalQuantifier;
import org.apache.uima.ruta.rule.quantifier.PlusGreedy;
import org.apache.uima.ruta.rule.quantifier.PlusReluctant;
import org.apache.uima.ruta.rule.quantifier.QuestionGreedy;
import org.apache.uima.ruta.rule.quantifier.QuestionReluctant;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.rule.quantifier.StarGreedy;
import org.apache.uima.ruta.rule.quantifier.StarReluctant;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ScriptVerbalizer {
    private static final String COLON = ":";
    private static final String CBCLOSE = "}";
    private static final String CBOPEN = "{";
    private static final String THEN = "->";
    private static final String THEN2 = "<-";
    private RutaVerbalizer verbalizer;

    public ScriptVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeBlock(RutaBlock block, boolean withElements) {
        StringBuilder result = new StringBuilder();
        RutaRule rule = block.getRule();
        List<RutaStatement> elements = block.getElements();
        String name = block.getName();
        if (block instanceof ForEachBlock) {
            result.append("FOREACH");
        } else {
            result.append("BLOCK");
        }
        if (name != null) {
            IBooleanExpression direction;
            result.append("(");
            result.append(name);
            if (block instanceof ForEachBlock && (direction = ((ForEachBlock)block).getDirection()) != null) {
                result.append(", ");
                result.append(this.verbalizer.verbalize(direction));
            }
            result.append(")");
        }
        result.append(" ");
        if (rule != null) {
            result.append(this.verbalizeRule(rule));
        }
        if (withElements) {
            result.append(" {\n");
            for (RutaStatement each : elements) {
                if (each instanceof RutaBlock) {
                    result.append(this.verbalizeBlock((RutaBlock)each, withElements));
                } else if (each instanceof RutaRule) {
                    result.append(this.verbalizeRule((RutaRule)each));
                }
                result.append(";");
                result.append("\n");
            }
            result.append(" }\n");
        }
        return result.toString();
    }

    public String verbalizeRule(RutaRule rule) {
        List<RuleElement> elements = rule.getRuleElements();
        StringBuilder result = new StringBuilder();
        Iterator<RuleElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            RuleElement each = iterator.next();
            result.append(this.verbalizeRuleElement(each));
            if (!iterator.hasNext()) continue;
            result.append(" ");
        }
        result.append(";");
        return result.toString();
    }

    public String verbalizeRuleElement(RuleElement re) {
        List<AbstractRutaCondition> conditions = re.getConditions();
        List<AbstractRutaAction> actions2 = re.getActions();
        RuleElementQuantifier quantifier = re.getQuantifier();
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isBlank(re.getLabel())) {
            result.append(re.getLabel());
            result.append(COLON);
        }
        if (re.isStartAnchor()) {
            result.append("@");
        }
        if (re instanceof ConjunctRulesRuleElement) {
            result.append(this.verbalizeConjunct((ConjunctRulesRuleElement)re));
        } else if (re instanceof ComposedRuleElement) {
            result.append(this.verbalizeComposed((ComposedRuleElement)re));
        } else if (re instanceof RutaOptionalRuleElement) {
            result.append("_");
        } else if (re instanceof RutaRuleElement) {
            RutaRuleElement tmre = (RutaRuleElement)re;
            RutaMatcher matcher = tmre.getMatcher();
            boolean actionOnlyRule = false;
            if (matcher == null) {
                result.append("_");
            } else {
                IRutaExpression expression = matcher.getExpression();
                boolean bl = actionOnlyRule = expression == null;
                if (expression != null) {
                    String verbalize = this.verbalizer.verbalize(expression);
                    if (StringUtils.isBlank(verbalize)) {
                        actionOnlyRule = true;
                    } else {
                        result.append(verbalize);
                    }
                }
            }
            if (actionOnlyRule) {
                Iterator<AbstractRutaAction> ait = actions2.iterator();
                while (ait.hasNext()) {
                    AbstractRutaAction each = ait.next();
                    result.append(this.verbalizer.verbalize(each));
                    if (!ait.hasNext()) continue;
                    result.append(",");
                }
                return result.toString();
            }
        } else if (re instanceof WildCardRuleElement) {
            result.append("#");
        }
        result.append(this.verbalizeQuantifier(quantifier));
        if (!conditions.isEmpty() || !actions2.isEmpty()) {
            result.append(CBOPEN);
            Iterator<AbstractRutaCondition> cit = conditions.iterator();
            while (cit.hasNext()) {
                AbstractRutaCondition each = cit.next();
                result.append(this.verbalizer.verbalize(each));
                if (!cit.hasNext()) continue;
                result.append(",");
            }
            if (!actions2.isEmpty()) {
                result.append(THEN);
                Iterator<AbstractRutaAction> ait = actions2.iterator();
                while (ait.hasNext()) {
                    AbstractRutaAction each = ait.next();
                    result.append(this.verbalizer.verbalize(each));
                    if (!ait.hasNext()) continue;
                    result.append(",");
                }
            }
            result.append(CBCLOSE);
        }
        if (re instanceof AbstractRuleElement) {
            AbstractRuleElement are = (AbstractRuleElement)re;
            List<List<RutaStatement>> inlinedConditionRuleBlocks = are.getInlinedConditionRuleBlocks();
            for (List<RutaStatement> inlinedConditionRules : inlinedConditionRuleBlocks) {
                result.append(this.verbalizeInlinedConditionRuleBlock(inlinedConditionRules));
            }
            List<List<RutaStatement>> inlinedActionRuleBlocks = are.getInlinedActionRuleBlocks();
            for (List<RutaStatement> inlinedActionRules : inlinedActionRuleBlocks) {
                result.append(this.verbalizeInlinedActionRuleBlock(inlinedActionRules));
            }
        }
        return result.toString();
    }

    public String verbalizeInlinedActionRuleBlock(List<RutaStatement> inlinedActionRules) {
        StringBuilder result = new StringBuilder();
        if (inlinedActionRules != null && !inlinedActionRules.isEmpty()) {
            result.append(THEN);
            result.append(CBOPEN);
            for (RutaStatement rutaStatement : inlinedActionRules) {
                result.append(this.verbalize(rutaStatement));
            }
            result.append(CBCLOSE);
        }
        return result.toString();
    }

    public String verbalizeInlinedConditionRuleBlock(List<RutaStatement> inlinedConditionRules) {
        StringBuilder result = new StringBuilder();
        if (inlinedConditionRules != null && !inlinedConditionRules.isEmpty()) {
            result.append(THEN2);
            result.append(CBOPEN);
            for (RutaStatement rutaStatement : inlinedConditionRules) {
                result.append(this.verbalize(rutaStatement));
            }
            result.append(CBCLOSE);
        }
        return result.toString();
    }

    public String verbalizeInlinedConditionRuleApplyBlock(List<ScriptApply> block) {
        List<RutaStatement> list = block.stream().map(a -> a.getElement()).filter(RutaStatement.class::isInstance).map(s2 -> (RutaStatement)s2).collect(Collectors.toList());
        return this.verbalizeInlinedConditionRuleBlock(list);
    }

    public String verbalizeInlinedActionRuleApplyBlock(List<ScriptApply> block) {
        List<RutaStatement> list = block.stream().map(a -> a.getElement()).filter(RutaStatement.class::isInstance).map(s2 -> (RutaStatement)s2).collect(Collectors.toList());
        return this.verbalizeInlinedActionRuleBlock(list);
    }

    private String verbalizeConjunct(ConjunctRulesRuleElement re) {
        StringBuilder result = new StringBuilder();
        String sep = " % ";
        List<RuleElement> ruleElements = re.getRuleElements();
        for (RuleElement each : ruleElements) {
            if (re.getRuleElements().indexOf(each) != 0) {
                result.append(sep);
            }
            result.append(this.verbalizeRuleElement(each));
        }
        return result.toString();
    }

    public String verbalizeComposed(ComposedRuleElement cre) {
        StringBuilder result = new StringBuilder();
        List<RuleElement> ruleElements = cre.getRuleElements();
        result.append("(");
        String sep = " ";
        Boolean conjunct = cre.getConjunct();
        if (conjunct != null) {
            sep = conjunct != false ? " & " : " | ";
        }
        for (RuleElement each : ruleElements) {
            if (cre.getRuleElements().indexOf(each) != 0) {
                result.append(sep);
            }
            result.append(this.verbalizeRuleElement(each));
        }
        result.append(")");
        return result.toString();
    }

    public String verbalizeMatcher(RutaRuleElement re) {
        StringBuilder result = new StringBuilder();
        RutaMatcher matcher = re.getMatcher();
        if (matcher != null) {
            result.append(this.verbalizer.verbalize(matcher.getExpression()));
        }
        return result.toString();
    }

    public String verbalizeQuantifier(RuleElementQuantifier quantifier) {
        if (quantifier instanceof NormalQuantifier) {
            return "";
        }
        if (quantifier instanceof MinMaxGreedy) {
            MinMaxGreedy mmg = (MinMaxGreedy)quantifier;
            return "[" + this.verbalizer.verbalize(mmg.getMin()) + "," + this.verbalizer.verbalize(mmg.getMax()) + "]";
        }
        if (quantifier instanceof MinMaxReluctant) {
            MinMaxReluctant mmr = (MinMaxReluctant)quantifier;
            return "[" + this.verbalizer.verbalize(mmr.getMin()) + "," + this.verbalizer.verbalize(mmr.getMax()) + "]?";
        }
        if (quantifier instanceof PlusGreedy) {
            return "+";
        }
        if (quantifier instanceof PlusReluctant) {
            return "+?";
        }
        if (quantifier instanceof QuestionGreedy) {
            return "?";
        }
        if (quantifier instanceof QuestionReluctant) {
            return "??";
        }
        if (quantifier instanceof StarGreedy) {
            return "*";
        }
        if (quantifier instanceof StarReluctant) {
            return "*?";
        }
        return null;
    }

    public String verbalize(RutaElement element) {
        if (element instanceof RutaBlock) {
            return this.verbalizeBlock((RutaBlock)element, false);
        }
        if (element instanceof RuleElementQuantifier) {
            return this.verbalizeQuantifier((RuleElementQuantifier)((Object)element));
        }
        if (element instanceof RutaRule) {
            return this.verbalizeRule((RutaRule)element);
        }
        if (element instanceof RegExpRule) {
            return this.verbalizeRegExpRule((RegExpRule)element);
        }
        if (element instanceof RutaRuleElement) {
            return this.verbalizeRuleElement((RutaRuleElement)element);
        }
        return null;
    }

    private String verbalizeRegExpRule(RegExpRule rule) {
        StringBuilder sb = new StringBuilder();
        String regexp = this.verbalizer.verbalize(rule.getRegExp());
        sb.append(regexp);
        sb.append(THEN);
        Iterator<Map.Entry<ITypeExpression, INumberExpression>> iterator = rule.getTypeMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map<IStringExpression, IRutaExpression> map;
            Map.Entry<ITypeExpression, INumberExpression> next = iterator.next();
            String type = this.verbalizer.verbalize(next.getKey());
            INumberExpression value = next.getValue();
            if (value != null) {
                String group = this.verbalizer.verbalize(value);
                sb.append(group + " = " + type);
            } else {
                sb.append(type);
            }
            Map<ITypeExpression, Map<IStringExpression, IRutaExpression>> featureAssignments = rule.getFeatureAssignments();
            if (featureAssignments != null && (map = featureAssignments.get(next.getKey())) != null) {
                sb.append("(");
                Iterator<Map.Entry<IStringExpression, IRutaExpression>> fit = map.entrySet().iterator();
                while (fit.hasNext()) {
                    Map.Entry<IStringExpression, IRutaExpression> entry = fit.next();
                    sb.append(this.verbalizer.verbalize(entry.getKey()));
                    sb.append(" = ");
                    sb.append(this.verbalizer.verbalize(entry.getValue()));
                    if (!fit.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(";");
        return sb.toString();
    }
}

