/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.seed;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.seed.TextSeeder;
import org.apache.uima.ruta.type.MARKUP;

public class DefaultSeeder
extends TextSeeder {
    public static final String seedType = "org.apache.uima.ruta.type.TokenSeed";
    private final Pattern markupPattern = Pattern.compile("</?\\w[\\w-]*((\\s+[\\w-]+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>");

    @Override
    public Type seed(String text, CAS cas) {
        Type result = super.seed(text, cas);
        JCas jCas = null;
        try {
            jCas = cas.getJCas();
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        if (text != null) {
            Matcher matcher = this.markupPattern.matcher(text);
            LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
            while (matcher.find()) {
                int begin = matcher.start();
                int end = matcher.end();
                MARKUP markup = new MARKUP(jCas, begin, end);
                markup.addToIndexes();
                List<AnnotationFS> selectCovered = CasUtil.selectCovered(result, markup);
                toRemove.addAll(selectCovered);
            }
            for (AnnotationFS each : toRemove) {
                cas.removeFsFromIndexes(each);
            }
        }
        return result;
    }
}

