/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaProcessRuntimeException;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.quantifier.NormalQuantifier;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RutaOptionalRuleElement
extends RutaRuleElement {
    public RutaOptionalRuleElement(List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        super(null, new NormalQuantifier(), conditions, actions2, container, parent);
    }

    @Override
    public Collection<? extends AnnotationFS> getAnchors(RutaStream stream) {
        throw new RutaProcessRuntimeException("Using an optional rule lement as anchor is not allowed!");
    }

    @Override
    public List<RuleMatch> startMatch(RuleMatch ruleMatch, RuleApply ruleApply, ComposedRuleElementMatch containerMatch, RuleElement entryPoint, RutaStream stream, InferenceCrowd crowd) {
        throw new RutaProcessRuntimeException("Using an optional rule lement as anchor is not allowed!");
    }

    @Override
    public void doMatch(boolean after, AnnotationFS annotation, RuleMatch ruleMatch, ComposedRuleElementMatch containerMatch, boolean ruleAnchor, RutaStream stream, InferenceCrowd crowd) {
        RuleElementMatch result = new RuleElementMatch(this, containerMatch);
        result.setRuleAnchor(ruleAnchor);
        ArrayList<EvaluatedCondition> evaluatedConditions = new ArrayList<EvaluatedCondition>(this.conditions.size());
        boolean base = true;
        MatchContext context = new MatchContext(annotation, this, ruleMatch, after);
        ArrayList<AnnotationFS> textsMatched = new ArrayList<AnnotationFS>(1);
        if (annotation != null) {
            textsMatched.add(annotation);
        }
        result.setMatchInfo(base, textsMatched, stream);
        RutaEnvironment environment = context.getParent().getEnvironment();
        environment.addMatchToVariable(ruleMatch, this, context, stream);
        if (base) {
            for (AbstractRutaCondition condition : this.conditions) {
                crowd.beginVisit(condition, null);
                EvaluatedCondition eval = condition.eval(context, stream, crowd);
                crowd.endVisit(condition, null);
                evaluatedConditions.add(eval);
                if (eval.isValue()) continue;
                break;
            }
        }
        result.setConditionInfo(base, evaluatedConditions);
        if (result.matched()) {
            boolean inlinedRulesMatched = this.matchInlinedRules(ruleMatch, result, stream, crowd);
            result.setInlinedRulesMatched(inlinedRulesMatched);
        } else {
            environment.removeVariableValue(this.getLabel(), context);
        }
        ruleMatch.setMatched(ruleMatch.matched() && result.matched());
    }

    @Override
    protected boolean isNotConsumable(Collection<? extends AnnotationFS> nextAnnotations) {
        return false;
    }

    @Override
    public String toString() {
        return "_";
    }

    @Override
    public long estimateAnchors(RutaStream stream) {
        return Integer.MAX_VALUE;
    }

    @Override
    public Collection<? extends AnnotationFS> getNextAnnotations(boolean after, AnnotationFS annotation, RutaStream stream) {
        return Arrays.asList(stream.getBasicNextTo(!after, annotation));
    }
}

