/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.ComposedRuleElementMatch;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.type.RutaOptional;

public class RuleMatch
extends AbstractRuleMatch<RutaRule> {
    private boolean applied = false;
    private Map<RutaElement, ScriptApply> delegateApply = new HashMap<RutaElement, ScriptApply>(0);
    private ComposedRuleElementMatch rootMatch;

    public RuleMatch(RutaRule rule) {
        super(rule);
    }

    @Override
    public boolean matchedCompletely() {
        return this.matched && this.rootMatch.matched();
    }

    public List<AnnotationFS> getMatchedAnnotationsOfElement(RuleElement element) {
        return this.getMatchedAnnotations(element.getSelfIndexList(), element.getContainer());
    }

    public AnnotationFS getLastMatchedAnnotation(MatchContext context, RutaStream stream) {
        RuleElement element = context.getElement();
        AnnotationFS annotation = context.getAnnotation();
        boolean direction = context.getDirection();
        List<AnnotationFS> matchedAnnotations = this.getMatchedAnnotationsOfElement(element);
        if (matchedAnnotations.isEmpty()) {
            if (element.getQuantifier().isOptional(context, stream)) {
                return annotation;
            }
            return null;
        }
        if (direction) {
            AnnotationFS matched = matchedAnnotations.get(matchedAnnotations.size() - 1);
            if (annotation != null && matched.getEnd() < annotation.getEnd()) {
                return annotation;
            }
            return matched;
        }
        AnnotationFS matched = matchedAnnotations.get(0);
        if (annotation != null && matched.getBegin() > annotation.getBegin()) {
            return annotation;
        }
        return matched;
    }

    @Override
    public List<AnnotationFS> getMatchedAnnotationsOfRoot() {
        return this.getMatchedAnnotationsOfElement(((RutaRule)this.getRule()).getRoot());
    }

    public List<AnnotationFS> getMatchedAnnotations(List<Integer> indexes, RuleElementContainer container) {
        AnnotationFS firstNormal;
        List<AnnotationFS> list;
        List list2;
        RuleElement ruleElement;
        Object matchInfo;
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        indexes = RuleMatch.extendIndexes(indexes);
        if (container == null) {
            container = ((RutaRule)this.rule).getRoot();
        }
        if (indexes == null) {
            List<RuleElement> ruleElements = container.getRuleElements();
            indexes = new ArrayList<Integer>();
            for (RuleElement ruleElement2 : ruleElements) {
                indexes.add(ruleElements.indexOf(ruleElement2) + 1);
            }
        }
        if (indexes.size() == 1 && (matchInfo = this.getMatchInfo(ruleElement = container.getRuleElements().get(indexes.get(0) - 1))).size() == 1 && (list2 = (List)matchInfo.get(0)) != null && list2.size() == 1 && (list = ((RuleElementMatch)list2.get(0)).getTextsMatched()).size() == 1 && (firstNormal = this.getFirstNormal(list)) != null) {
            return list;
        }
        ArrayList reverseList = new ArrayList();
        for (Integer index : indexes) {
            if (index > container.getRuleElements().size()) continue;
            RuleElement ruleElement2 = container.getRuleElements().get(index - 1);
            List<List<RuleElementMatch>> matchInfo2 = this.getMatchInfo(ruleElement2);
            int i = 0;
            for (List<RuleElementMatch> list22 : matchInfo2) {
                if (reverseList.size() <= i) {
                    reverseList.add(new ArrayList());
                }
                List l = (List)reverseList.get(i);
                l.add(list22);
                ++i;
            }
        }
        CAS cas = null;
        for (List list3 : reverseList) {
            int begin = Integer.MAX_VALUE;
            int end = 0;
            AnnotationFS singleAnnotation = null;
            boolean mergingRequired = list3.size() > 1;
            for (List list23 : list3) {
                if (list23 == null) continue;
                if (list23.size() > 1) {
                    mergingRequired = true;
                }
                if (list23.size() == 1 && !mergingRequired) {
                    RuleElementMatch ruleElementMatch = (RuleElementMatch)list23.get(0);
                    List<AnnotationFS> textsMatched2 = ruleElementMatch.getTextsMatched();
                    if (textsMatched2 != null && textsMatched2.size() == 1) {
                        singleAnnotation = textsMatched2.get(0);
                    } else {
                        mergingRequired = true;
                    }
                }
                if (!mergingRequired) continue;
                for (RuleElementMatch ruleElementMatch : list23) {
                    AnnotationFS last;
                    List<AnnotationFS> textsMatched3 = ruleElementMatch.getTextsMatched();
                    if (textsMatched3 == null || textsMatched3.isEmpty()) continue;
                    AnnotationFS first = this.getFirstNormal(textsMatched3);
                    if (first != null) {
                        begin = Math.min(first.getBegin(), begin);
                    }
                    if ((last = this.getLastNormal(textsMatched3)) != null) {
                        end = Math.max(last.getEnd(), end);
                    }
                    if (cas != null || first == null) continue;
                    cas = first.getCAS();
                }
            }
            if (singleAnnotation != null && !(singleAnnotation instanceof RutaOptional)) {
                result.add(singleAnnotation);
                continue;
            }
            if (cas == null || end == 0) continue;
            AnnotationFS annotation = cas.createAnnotation(cas.getAnnotationType(), begin, end);
            result.add(annotation);
        }
        return result;
    }

    private AnnotationFS getFirstNormal(List<AnnotationFS> textsMatched) {
        int pointer;
        AnnotationFS fs;
        AnnotationFS annotationFS = null;
        if (textsMatched.size() == 0) {
            return null;
        }
        if (textsMatched.size() == 1 && (fs = textsMatched.get(0)).getType().getName().equals("org.apache.uima.ruta.type.RutaOptional")) {
            return null;
        }
        for (pointer = 0; pointer < textsMatched.size() && (annotationFS = textsMatched.get(pointer)) != null && annotationFS.getType().getName().equals("org.apache.uima.ruta.type.RutaOptional"); ++pointer) {
        }
        if (pointer < textsMatched.size()) {
            return annotationFS;
        }
        return null;
    }

    private AnnotationFS getLastNormal(List<AnnotationFS> textsMatched) {
        int pointer;
        AnnotationFS annotationFS = null;
        for (pointer = textsMatched.size() - 1; pointer >= 0 && (annotationFS = textsMatched.get(pointer)) != null && annotationFS.getType().getName().equals("org.apache.uima.ruta.type.RutaOptional"); --pointer) {
        }
        if (pointer >= 0) {
            return annotationFS;
        }
        return null;
    }

    public static List<Integer> extendIndexes(List<Integer> indexes) {
        if (indexes == null || indexes.size() <= 1) {
            return indexes;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int pointer = indexes.get(0);
        for (Integer each : indexes) {
            while (pointer < each - 1) {
                result.add(++pointer);
            }
            result.add(each);
            pointer = each;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.matched ? "Matched : " : "Not Matched :");
        result.append(this.getRootMatch());
        return result.toString();
    }

    public Map<RutaElement, ScriptApply> getDelegateApply() {
        return this.delegateApply;
    }

    public void addDelegateApply(RutaElement element, ScriptApply scriptApply) {
        this.delegateApply.put(element, scriptApply);
    }

    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    public RuleMatch copy(ComposedRuleElementMatch extendedContainerMatch, boolean after) {
        RuleMatch copy = new RuleMatch((RutaRule)this.rule);
        copy.setMatched(this.matched);
        if (extendedContainerMatch.getContainerMatch() == null) {
            copy.setRootMatch(extendedContainerMatch);
        } else {
            copy.setRootMatch(this.rootMatch.copy2(extendedContainerMatch, after));
        }
        HashMap<RutaElement, ScriptApply> newDelegateApply = new HashMap<RutaElement, ScriptApply>(this.delegateApply);
        copy.setDelegateApply(newDelegateApply);
        return copy;
    }

    public RuleMatch copy() {
        RuleMatch copy = new RuleMatch((RutaRule)this.rule);
        copy.setMatched(this.matched);
        copy.setRootMatch(this.rootMatch.copy());
        HashMap<RutaElement, ScriptApply> newDelegateApply = new HashMap<RutaElement, ScriptApply>(this.delegateApply);
        copy.setDelegateApply(newDelegateApply);
        return copy;
    }

    public void update(ComposedRuleElementMatch extendedContainerMatch) {
        if (extendedContainerMatch.getContainerMatch() == null) {
            this.setRootMatch(extendedContainerMatch);
        } else {
            this.rootMatch.update(extendedContainerMatch);
        }
    }

    public void setDelegateApply(Map<RutaElement, ScriptApply> delegateApply) {
        this.delegateApply = delegateApply;
    }

    public boolean isApplied() {
        return this.applied;
    }

    public void setApplied(boolean applied) {
        this.applied = applied;
    }

    public ComposedRuleElementMatch getRootMatch() {
        return this.rootMatch;
    }

    public void setRootMatch(ComposedRuleElementMatch rootMatch) {
        this.rootMatch = rootMatch;
    }

    public List<List<RuleElementMatch>> getMatchInfo(RuleElement element) {
        return this.getMatchInfo(this.rootMatch, element);
    }

    public List<List<RuleElementMatch>> getMatchInfo(RuleElementMatch rootMatch, RuleElement element) {
        ArrayList<List<RuleElementMatch>> result = new ArrayList<List<RuleElementMatch>>();
        RuleElement root = rootMatch.getRuleElement();
        if (element.equals(root)) {
            ArrayList<RuleElementMatch> list = new ArrayList<RuleElementMatch>(1);
            list.add(rootMatch);
            result.add(list);
        } else if (rootMatch instanceof ComposedRuleElementMatch) {
            ComposedRuleElementMatch crem = (ComposedRuleElementMatch)rootMatch;
            Set<Map.Entry<RuleElement, List<RuleElementMatch>>> entrySet = crem.getInnerMatches().entrySet();
            for (Map.Entry<RuleElement, List<RuleElementMatch>> entry : entrySet) {
                List<RuleElementMatch> value = entry.getValue();
                if (element.equals(entry.getKey())) {
                    result.add(value);
                    continue;
                }
                if (value == null) continue;
                for (RuleElementMatch eachMatch : value) {
                    result.addAll(this.getMatchInfo(eachMatch, element));
                }
            }
        }
        return result;
    }

    public RuleElementMatch getLastMatch(RuleElement ruleElement, boolean direction) {
        List<List<RuleElementMatch>> matchInfo = this.getMatchInfo(ruleElement);
        if (matchInfo == null || matchInfo.isEmpty()) {
            return null;
        }
        if (direction) {
            List<RuleElementMatch> list = matchInfo.get(matchInfo.size() - 1);
            if (list != null && !list.isEmpty()) {
                return list.get(list.size() - 1);
            }
        } else {
            List<RuleElementMatch> list = matchInfo.get(0);
            if (list != null && !list.isEmpty()) {
                return list.get(0);
            }
        }
        return null;
    }
}

