/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.AbstractStringExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.AbstractRule;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RegExpRuleMatch;
import org.apache.uima.ruta.rule.RuleApply;
import org.apache.uima.ruta.utils.UIMAUtils;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RegExpRule
extends AbstractRule {
    private Map<ITypeExpression, INumberExpression> typeMap;
    private IStringExpression regexpExpr;
    private Map<ITypeExpression, Map<IStringExpression, IRutaExpression>> featureAssignments;

    public RegExpRule(AbstractStringExpression regexp, Map<ITypeExpression, INumberExpression> typeMap, int id, RutaBlock parent) {
        super(parent, id);
        this.regexpExpr = regexp;
        this.typeMap = typeMap;
    }

    @Override
    public ScriptApply apply(RutaStream stream, InferenceCrowd crowd) {
        RuleApply ruleApply = new RuleApply(this, false);
        crowd.beginVisit(this, ruleApply);
        MatchContext context = new MatchContext(this.getParent());
        String regexpString = this.regexpExpr.getStringValue(context, stream);
        if (regexpString == null) {
            crowd.endVisit(this, ruleApply);
            return ruleApply;
        }
        AnnotationFS documentAnnotation = stream.getDocumentAnnotation();
        String document = documentAnnotation.getCoveredText();
        int delta = documentAnnotation.getBegin();
        Map<Integer, List<Type>> groupTypes = this.getGroup2Types(context, stream);
        Map<Integer, Map<Type, Map<String, Object>>> fa = this.getFeatureAssignmentMap(stream);
        Pattern pattern = Pattern.compile(regexpString, 40);
        Matcher matcher = pattern.matcher(document);
        int groupCount = matcher.groupCount();
        while (matcher.find()) {
            RegExpRuleMatch ruleMatch = new RegExpRuleMatch(this);
            MatchResult matchResult = matcher.toMatchResult();
            for (int i = 0; i <= groupCount; ++i) {
                int begin = matchResult.start(i);
                int end = matchResult.end(i);
                List<Type> types = groupTypes.get(i);
                if (types != null) {
                    this.createAnnotations(i, delta, begin, end, types, fa, matchResult, ruleMatch, stream);
                    continue;
                }
                if (i != 0) continue;
                CAS cas = stream.getCas();
                AnnotationFS afs = cas.createAnnotation(cas.getAnnotationType(), delta + begin, delta + end);
                ruleMatch.addMatched(0, afs);
            }
            List<AnnotationFS> matchedAnnotationsOfRoot = ruleMatch.getMatchedAnnotationsOfRoot();
            if (matchedAnnotationsOfRoot == null || matchedAnnotationsOfRoot.isEmpty()) continue;
            ruleApply.add(ruleMatch, stream);
        }
        crowd.endVisit(this, ruleApply);
        return ruleApply;
    }

    private Map<Integer, Map<Type, Map<String, Object>>> getFeatureAssignmentMap(RutaStream stream) {
        HashMap<Integer, Map<Type, Map<String, Object>>> result = new HashMap<Integer, Map<Type, Map<String, Object>>>();
        Set<Map.Entry<ITypeExpression, Map<IStringExpression, IRutaExpression>>> entrySet = this.featureAssignments.entrySet();
        MatchContext context = new MatchContext(this.getParent());
        for (Map.Entry<ITypeExpression, Map<IStringExpression, IRutaExpression>> entry : entrySet) {
            HashMap<String, IRutaExpression> typeMap;
            ITypeExpression key = entry.getKey();
            Type type = key.getType(context, stream);
            Map<IStringExpression, IRutaExpression> value = entry.getValue();
            INumberExpression cgExpr = this.typeMap.get(key);
            int cg = cgExpr == null ? 0 : cgExpr.getIntegerValue(context, stream);
            HashMap map = (HashMap)result.get(cg);
            if (map == null) {
                map = new HashMap();
                result.put(cg, map);
            }
            if ((typeMap = (HashMap<String, IRutaExpression>)map.get(type)) == null) {
                typeMap = new HashMap<String, IRutaExpression>();
                map.put(type, typeMap);
            }
            Set<Map.Entry<IStringExpression, IRutaExpression>> entrySet2 = value.entrySet();
            for (Map.Entry<IStringExpression, IRutaExpression> entry2 : entrySet2) {
                IStringExpression key2 = entry2.getKey();
                IRutaExpression value2 = entry2.getValue();
                String stringValue = key2.getStringValue(context, stream);
                typeMap.put(stringValue, value2);
            }
        }
        return result;
    }

    private Map<Integer, List<Type>> getGroup2Types(MatchContext context, RutaStream stream) {
        TreeMap<Integer, List<Type>> groupTypes = new TreeMap<Integer, List<Type>>();
        Set<Map.Entry<ITypeExpression, INumberExpression>> entrySet = this.typeMap.entrySet();
        for (Map.Entry<ITypeExpression, INumberExpression> entry : entrySet) {
            Type type = entry.getKey().getType(context, stream);
            INumberExpression value = entry.getValue();
            int group = value == null ? 0 : value.getIntegerValue(context, stream);
            ArrayList<Type> list = (ArrayList<Type>)groupTypes.get(group);
            if (list == null) {
                list = new ArrayList<Type>();
                groupTypes.put(group, list);
            }
            list.add(type);
        }
        return groupTypes;
    }

    private void createAnnotations(int group, int delta, int begin, int end, List<Type> globalTypes, Map<Integer, Map<Type, Map<String, Object>>> fa, MatchResult matchResult, RegExpRuleMatch match, RutaStream stream) {
        CAS cas = stream.getCas();
        if (begin < end) {
            for (Type type : globalTypes) {
                AnnotationFS afs = cas.createAnnotation(type, delta + begin, delta + end);
                this.fillFeatures(group, afs, fa, delta, matchResult, stream);
                match.addMatched(group, afs);
                stream.addAnnotation(afs, true, true, match);
            }
        }
    }

    private void fillFeatures(int group, AnnotationFS afs, Map<Integer, Map<Type, Map<String, Object>>> fa, int delta, MatchResult matchResult, RutaStream stream) {
        Map<String, Object> map;
        Type type = afs.getType();
        JCas jcas = null;
        CAS cas = stream.getCas();
        try {
            jcas = cas.getJCas();
        }
        catch (CASException cASException) {
            // empty catch block
        }
        MatchContext context = new MatchContext(null, null, null, true);
        TypeSystem typeSystem = cas.getTypeSystem();
        Map<Type, Map<String, Object>> typeMap = fa.get(group);
        if (typeMap != null && (map = typeMap.get(type)) != null) {
            for (Map.Entry<String, Object> eachEntry : map.entrySet()) {
                AnnotationFS annotation;
                ITypeExpression typeExpr;
                String featureName = eachEntry.getKey();
                Feature feature = type.getFeatureByBaseName(featureName);
                if (feature == null) continue;
                Object argExpr = eachEntry.getValue();
                Type range = feature.getRange();
                if (argExpr instanceof INumberExpression) {
                    int end;
                    int begin;
                    INumberExpression ne = (INumberExpression)argExpr;
                    int cg = ne.getIntegerValue(context, stream);
                    if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
                        String s2 = matchResult.group(cg);
                        afs.setStringValue(feature, s2);
                        continue;
                    }
                    if (range.getName().equals("uima.cas.Boolean") || range.getName().equals("uima.cas.Byte") || range.getName().equals("uima.cas.Double") || range.getName().equals("uima.cas.Float") || range.getName().equals("uima.cas.Integer") || range.getName().equals("uima.cas.Long") || range.getName().equals("uima.cas.Short") || typeSystem.subsumes(jcas.getCasType(FSArray.type), range) || (begin = delta + matchResult.start(cg)) >= (end = delta + matchResult.end(cg))) continue;
                    AnnotationFS a = cas.createAnnotation(range, begin, end);
                    afs.setFeatureValue(feature, a);
                    continue;
                }
                if (argExpr instanceof ITypeExpression && typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
                    typeExpr = (ITypeExpression)argExpr;
                    List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow(afs, typeExpr.getType(context, stream));
                    if (annotationsInWindow == null || annotationsInWindow.isEmpty()) continue;
                    annotation = annotationsInWindow.get(0);
                    afs.setStringValue(feature, annotation.getCoveredText());
                    continue;
                }
                if (argExpr instanceof AbstractStringExpression && typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range)) {
                    afs.setStringValue(feature, ((AbstractStringExpression)argExpr).getStringValue(context, stream));
                    continue;
                }
                if (argExpr instanceof IBooleanExpression && range.getName().equals("uima.cas.Boolean")) {
                    afs.setBooleanValue(feature, ((IBooleanExpression)argExpr).getBooleanValue(context, stream));
                    continue;
                }
                if (!(argExpr instanceof ITypeExpression)) continue;
                typeExpr = (ITypeExpression)argExpr;
                List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow(afs, typeExpr.getType(context, stream));
                if (typeSystem.subsumes(jcas.getCasType(FSArray.type), range)) {
                    afs.setFeatureValue(feature, UIMAUtils.toFSArray(jcas, annotationsInWindow));
                    continue;
                }
                if (!typeSystem.subsumes(range, typeExpr.getType(context, stream)) || annotationsInWindow.isEmpty()) continue;
                annotation = annotationsInWindow.get(0);
                afs.setFeatureValue(feature, annotation);
            }
        }
    }

    @Override
    public RutaEnvironment getEnvironment() {
        return this.getParent().getEnvironment();
    }

    public Map<ITypeExpression, INumberExpression> getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map<ITypeExpression, INumberExpression> typeMap) {
        this.typeMap = typeMap;
    }

    public IStringExpression getRegExp() {
        return this.regexpExpr;
    }

    public void setRegExp(IStringExpression regexp) {
        this.regexpExpr = regexp;
    }

    public void setFeatureAssignments(Map<ITypeExpression, Map<IStringExpression, IRutaExpression>> fa) {
        this.featureAssignments = fa;
    }

    public Map<ITypeExpression, Map<IStringExpression, IRutaExpression>> getFeatureAssignments() {
        return this.featureAssignments;
    }
}

