/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

public class AnnotationListFSIterator
extends FSIteratorImplBase<AnnotationFS> {
    private final List<AnnotationFS> list;
    private int pointer = 0;

    public AnnotationListFSIterator(List<AnnotationFS> list) {
        this.list = list;
    }

    @Override
    public boolean isValid() {
        return this.pointer >= 0 && this.pointer < this.list.size();
    }

    @Override
    public AnnotationFS get() throws NoSuchElementException {
        return this.list.get(this.pointer);
    }

    @Override
    public void moveToNext() {
        ++this.pointer;
    }

    @Override
    public void moveToPrevious() {
        --this.pointer;
    }

    @Override
    public void moveToFirst() {
        this.pointer = 0;
    }

    @Override
    public void moveToLast() {
        this.pointer = this.list.size() - 1;
    }

    @Override
    public void moveTo(FeatureStructure fs) {
        for (int i = 0; i < this.list.size(); ++i) {
            AnnotationFS each = this.list.get(i);
            if (!each.equals(fs)) continue;
            this.pointer = i;
            break;
        }
    }

    @Override
    public FSIterator<AnnotationFS> copy() {
        return new AnnotationListFSIterator(this.list);
    }
}

