/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.resource.MultiTreeWordListPersistence;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TextNode;
import org.apache.uima.ruta.resource.XMLEventHandler;
import org.apache.uima.ruta.type.RutaBasic;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TreeWordList
implements RutaWordList {
    private TextNode root;
    private String name;
    private boolean dictRemoveWS;

    public TreeWordList() {
        this.dictRemoveWS = false;
        this.root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeWordList(Resource resource, boolean dictRemoveWS) throws IOException {
        String name;
        block7: {
            this.dictRemoveWS = false;
            this.dictRemoveWS = dictRemoveWS;
            name = resource.getFilename();
            try (InputStream stream = null;){
                stream = resource.getInputStream();
                if (name == null) {
                    throw new IllegalArgumentException("List does not have a name.");
                }
                if (name.endsWith(".txt")) {
                    this.buildNewTree(stream);
                    break block7;
                }
                if (name.endsWith(".twl")) {
                    this.readXML(stream, "UTF-8");
                    break block7;
                }
                throw new IllegalArgumentException("File name should end with .twl or .txt, found " + name);
            }
        }
        this.name = name;
    }

    public TreeWordList(String pathname, boolean dictRemoveWS) throws IOException {
        this(new FileSystemResource(pathname), dictRemoveWS);
    }

    public TreeWordList(InputStream stream, String name, boolean dictRemoveWS) throws IOException {
        this.dictRemoveWS = false;
        this.dictRemoveWS = dictRemoveWS;
        if (name.endsWith(".twl")) {
            this.readXML(stream, "UTF-8");
        }
        if (name.endsWith(".txt")) {
            this.buildNewTree(stream);
        }
        this.name = new File(name).getName();
    }

    public TreeWordList(List<String> data, boolean dictRemoveWS) {
        this.dictRemoveWS = false;
        this.name = "local";
        this.dictRemoveWS = dictRemoveWS;
        this.buildNewTree(data);
    }

    public void buildNewTree(List<String> data) {
        this.root = new TextNode();
        if (data == null) {
            return;
        }
        for (String s2 : data) {
            this.addWord(s2);
        }
    }

    public void buildNewTree(InputStream stream) throws IOException {
        Scanner scan = new Scanner(stream, "UTF-8");
        this.root = new TextNode();
        while (scan.hasNextLine()) {
            String s2 = scan.nextLine().trim();
            if (s2.endsWith("=")) {
                s2 = s2.substring(0, s2.length() - 1);
                s2 = s2.trim();
            }
            this.addWord(s2);
        }
        scan.close();
    }

    public TextNode getRoot() {
        return this.root;
    }

    public void addWord(String s2) {
        if (s2 == null) {
            return;
        }
        TextNode pointer = this.root;
        char[] cArray = s2.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character each = Character.valueOf(cArray[i]);
            if (this.dictRemoveWS && Character.isWhitespace(each.charValue())) continue;
            TextNode childNode = pointer.getChildNode(each.charValue());
            if (childNode == null) {
                childNode = new TextNode(each.charValue(), false);
                pointer.addChild(childNode);
            }
            pointer = childNode;
        }
        pointer.setWordEnd(s2.length() > 0);
    }

    @Override
    public boolean contains(String s2, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        if (s2 == null) {
            return false;
        }
        TextNode pointer = this.root;
        return this.recursiveContains(pointer, s2, 0, ignoreCase && s2.length() > size, false, ignoreChars, maxIgnoreChars, ignoreWS);
    }

    @Override
    public boolean containsFragment(String s2, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        TextNode pointer = this.root;
        return this.recursiveContains(pointer, s2, 0, ignoreCase && s2.length() > size, true, ignoreChars, maxIgnoreChars, ignoreWS);
    }

    private boolean recursiveContains(TextNode pointer, String text, int index, boolean ignoreCase, boolean fragment, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        if (pointer == null) {
            return false;
        }
        if (index == text.length()) {
            return fragment || pointer.isWordEnd();
        }
        char charAt = text.charAt(index);
        boolean charAtIgnored = false;
        if (ignoreChars != null) {
            for (char each : ignoreChars) {
                if (each != charAt) continue;
                charAtIgnored = true;
                --maxIgnoreChars;
                break;
            }
            charAtIgnored &= index != 0;
            if (maxIgnoreChars < 0) {
                return false;
            }
        }
        int next = ++index;
        boolean result = false;
        if (ignoreCase) {
            TextNode childNodeL = pointer.getChildNode(Character.toLowerCase(charAt));
            TextNode childNodeU = pointer.getChildNode(Character.toUpperCase(charAt));
            TextNode wsNode = pointer.getChildNode(' ');
            if (ignoreWS && wsNode != null) {
                result |= this.recursiveContains(wsNode, text, next - 1, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
            }
            if (childNodeL == null && ignoreWS) {
                childNodeL = this.skipWS(pointer, charAt);
            }
            if (childNodeU == null && ignoreWS) {
                childNodeU = this.skipWS(pointer, charAt);
            }
            if (charAtIgnored && childNodeL == null && childNodeU == null) {
                result |= this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
            } else {
                result |= this.recursiveContains(childNodeL, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
                if (childNodeL != childNodeU) {
                    result |= this.recursiveContains(childNodeU, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
                }
            }
        } else {
            TextNode childNode;
            TextNode wsNode = pointer.getChildNode(' ');
            if (ignoreWS && wsNode != null) {
                result |= this.recursiveContains(wsNode, text, next - 1, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS);
            }
            if ((childNode = pointer.getChildNode(charAt)) == null && ignoreWS) {
                childNode = this.skipWS(pointer, charAt);
            }
            result = charAtIgnored && childNode == null ? (result |= this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS)) : (result |= this.recursiveContains(childNode, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars, ignoreWS));
        }
        return result;
    }

    private TextNode skipWS(TextNode pointer, char charAt) {
        TextNode childNode = pointer.getChildNode(' ');
        if (childNode != null) {
            TextNode node = childNode.getChildNode(charAt);
            if (node == null) {
                return this.skipWS(childNode, charAt);
            }
            return node;
        }
        return null;
    }

    public List<AnnotationFS> find(RutaStream stream, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoredChars, boolean ignoreWS) {
        ArrayList<AnnotationFS> results = new ArrayList<AnnotationFS>();
        stream.moveToFirst();
        FSIterator<AnnotationFS> streamPointer = stream.copy();
        while (stream.isValid()) {
            RutaBasic anchorBasic = (RutaBasic)stream.get();
            streamPointer.moveTo(anchorBasic);
            ArrayList<RutaBasic> basicsToAdd = new ArrayList<RutaBasic>();
            basicsToAdd.add(anchorBasic);
            String text = anchorBasic.getCoveredText();
            StringBuilder candidate = new StringBuilder(text);
            Annotation interResult = null;
            while (streamPointer.isValid()) {
                if (this.containsFragment(candidate.toString(), ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
                    streamPointer.moveToNext();
                    if (streamPointer.isValid()) {
                        RutaBasic next = (RutaBasic)streamPointer.get();
                        if (this.contains(candidate.toString(), ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
                            interResult = new Annotation(stream.getJCas(), ((RutaBasic)basicsToAdd.get(0)).getBegin(), ((RutaBasic)basicsToAdd.get(basicsToAdd.size() - 1)).getEnd());
                        }
                        candidate.append(next.getCoveredText());
                        basicsToAdd.add(next);
                        continue;
                    }
                    this.tryToCreateAnnotation(stream, ignoreCase, size, results, basicsToAdd, candidate.toString(), interResult, ignoreChars, maxIgnoredChars, ignoreWS);
                    continue;
                }
                basicsToAdd.remove(basicsToAdd.size() - 1);
                this.tryToCreateAnnotation(stream, ignoreCase, size, results, basicsToAdd, candidate.toString(), interResult, ignoreChars, maxIgnoredChars, ignoreWS);
                break;
            }
            stream.moveToNext();
        }
        return results;
    }

    public List<AnnotationFS> find(RutaStream stream, boolean ignoreCase, int size, boolean ignoreWS) {
        return this.find(stream, ignoreCase, size, null, 0, ignoreWS);
    }

    private void tryToCreateAnnotation(RutaStream stream, boolean ignoreCase, int size, ArrayList<AnnotationFS> results, List<RutaBasic> basicsToAdd, String lastCandidate, Annotation interResult, char[] ignoreChars, int maxIgnoredChars, boolean ignoreWS) {
        if (basicsToAdd.size() >= 1 && this.contains(lastCandidate, ignoreCase, size, ignoreChars, maxIgnoredChars, ignoreWS)) {
            results.add(new Annotation(stream.getJCas(), basicsToAdd.get(0).getBegin(), basicsToAdd.get(basicsToAdd.size() - 1).getEnd()));
        } else if (interResult != null) {
            results.add(interResult);
        }
    }

    public void readXML(InputStream stream, String encoding) throws IOException {
        try {
            FilterInputStream is = new BufferedInputStream(stream);
            boolean isXml = MultiTreeWordListPersistence.isSniffedXmlContentType(is);
            if (!isXml) {
                is = new ZipInputStream(is);
                ((ZipInputStream)is).getNextEntry();
            }
            InputStreamReader streamReader = new InputStreamReader((InputStream)is, encoding);
            this.root = new TextNode();
            XMLEventHandler handler = new XMLEventHandler(this.root);
            XMLReader reader = XMLUtils.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(streamReader));
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public void createTWLFile(String path, String encoding) throws IOException {
        this.createTWLFile(this.root, path, true, encoding);
    }

    public void createTWLFile(String path, boolean compressed, String encoding) throws IOException {
        this.createTWLFile(this.root, path, compressed, encoding);
    }

    public void createTWLFile(TextNode root, String path, boolean compressed, String encoding) throws IOException {
        if (compressed) {
            this.writeCompressedTWLFile(root, path, encoding);
        } else {
            this.writeUncompressedMTWLFile(root, path, encoding);
        }
    }

    private void writeCompressedTWLFile(TextNode root, String path, String encoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ZipOutputStream zos = new ZipOutputStream(bos);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zos, encoding);
        zos.putNextEntry(new ZipEntry(path));
        this.writeTWLFile(root, writer);
        writer.flush();
        zos.closeEntry();
        writer.close();
    }

    private void writeUncompressedMTWLFile(TextNode root, String path, String encoding) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, encoding);
        this.writeTWLFile(root, writer);
        writer.close();
    }

    private void writeTWLFile(TextNode root, Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>");
        writer.write("<root>");
        for (TextNode child : root.getChildren().values()) {
            this.writeNode(writer, child);
        }
        writer.write("</root>");
    }

    public void writeNode(Writer writer, TextNode node) throws IOException {
        String value = StringEscapeUtils.escapeXml11(String.valueOf(node.getValue()));
        String output = "<node char=\"" + value + "\" isWordEnd=\"" + Boolean.toString(node.isWordEnd()) + "\">";
        writer.write(output);
        for (TextNode child : node.getChildren().values()) {
            this.writeNode(writer, child);
        }
        writer.write("</node>");
    }

    public String toString() {
        return this.name;
    }

    public List<AnnotationFS> find(RutaStream stream, Map<String, Object> typeMap, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public List<String> contains(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public List<String> containsFragment(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return null;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }
}

