/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.File;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ResourcePathResourceLoader
implements ResourceLoader {
    private final String[] resourcePaths;

    public ResourcePathResourceLoader(String[] resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    @Override
    public Resource getResource(String location) {
        if (this.resourcePaths != null) {
            for (String parent : this.resourcePaths) {
                File f = new File(parent, location);
                if (!f.exists()) continue;
                return new FileSystemResource(f);
            }
        }
        return new DescriptiveResource(location + " was not found in resource paths");
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

