/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.ruta.resource.MultiTextNode;
import org.apache.uima.ruta.resource.TrieXMLEventHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MultiTreeWordListPersistence {
    public void readMTWL(MultiTextNode root, String path) throws IOException {
        try (FileInputStream stream = new FileInputStream(path);){
            this.readMTWL(root, stream, "UTF-8");
        }
    }

    public static boolean isSniffedXmlContentType(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("Stream is null");
        }
        if (!is.markSupported()) {
            throw new IOException("Cannot mark stream. just wrap it in a BufferedInputStream");
        }
        byte[] bytes = new byte[5];
        is.mark(5);
        is.read(bytes);
        String prefix = new String(bytes);
        is.reset();
        return "<?xml".equals(prefix);
    }

    public void readMTWL(MultiTextNode root, InputStream stream, String encoding) throws IOException {
        try {
            FilterInputStream is = new BufferedInputStream(stream);
            boolean isXml = MultiTreeWordListPersistence.isSniffedXmlContentType(is);
            if (!isXml) {
                is = new ZipInputStream(is);
                ((ZipInputStream)is).getNextEntry();
            }
            InputStreamReader streamReader = new InputStreamReader((InputStream)is, encoding);
            TrieXMLEventHandler handler = new TrieXMLEventHandler(root);
            XMLReader reader = XMLUtils.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(handler);
            reader.parse(new InputSource(streamReader));
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public void createMTWLFile(MultiTextNode root, String path) throws IOException {
        this.createMTWLFile(root, path, true, "UTF-8");
    }

    public void createMTWLFile(MultiTextNode root, boolean compressed, String path) throws IOException {
        this.createMTWLFile(root, path, compressed, "UTF-8");
    }

    public void createMTWLFile(MultiTextNode root, String path, boolean compressed, String encoding) throws IOException {
        if (compressed) {
            this.writeCompressedMTWLFile(root, path, encoding);
        } else {
            this.writeUncompressedMTWLFile(root, path, encoding);
        }
    }

    private void writeCompressedMTWLFile(MultiTextNode root, String path, String encoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ZipOutputStream zos = new ZipOutputStream(bos);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zos, encoding);
        zos.putNextEntry(new ZipEntry(path));
        this.writeMTWLFile(root, writer);
        writer.flush();
        zos.closeEntry();
        writer.close();
    }

    private void writeUncompressedMTWLFile(MultiTextNode root, String path, String encoding) throws IOException {
        FileOutputStream output = new FileOutputStream(path);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, encoding);
        this.writeMTWLFile(root, writer);
        writer.close();
    }

    private void writeMTWLFile(MultiTextNode root, OutputStreamWriter writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?><root>");
        for (MultiTextNode node : root.getChildren().values()) {
            this.writeTextNode(writer, node);
        }
        writer.write("</root>");
    }

    private void writeTextNode(Writer writer, MultiTextNode node) {
        try {
            writer.write("\n");
            String s2 = "<n>";
            writer.write(s2);
            writer.write("<c><![CDATA[" + node.getValue() + "]]></c>");
            if (Boolean.valueOf(node.isWordEnd()).booleanValue()) {
                for (String type : node.getTypes()) {
                    String t = "<t>" + type + "</t>";
                    writer.write(t);
                }
            }
            for (MultiTextNode child : node.getChildren().values()) {
                this.writeTextNode(writer, child);
            }
            writer.write("</n>");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

