/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class CSVTable
implements RutaTable {
    public static final String DEFAULT_CSV_SEPARATOR = ";";
    private List<List<String>> tableData;
    private Map<Integer, RutaWordList> columnWordLists = new HashMap<Integer, RutaWordList>(2);
    private final String separator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSVTable(Resource table, String selectedSeparator) throws IOException {
        this.separator = selectedSeparator;
        try (InputStream stream = null;){
            stream = table.getInputStream();
            this.buildTable(stream);
        }
    }

    public CSVTable(String location, String selectedSeparator) throws IOException {
        this(new FileSystemResource(location), selectedSeparator);
    }

    public CSVTable(InputStream stream, String selectedSeparator) throws IOException {
        this.separator = selectedSeparator;
        this.buildTable(stream);
    }

    private void buildTable(InputStream stream) {
        Scanner sc = new Scanner(stream, Charset.forName("UTF-8").name());
        sc.useDelimiter("\\n");
        this.tableData = new ArrayList<List<String>>();
        while (sc.hasNext()) {
            String line = sc.next().trim();
            String quotedSeparator = Pattern.quote(this.separator);
            line = line.replaceAll(quotedSeparator + quotedSeparator, this.separator + " " + this.separator);
            String[] lineElements = line.split(quotedSeparator);
            List<String> row = Arrays.asList(lineElements);
            this.tableData.add(row);
        }
        sc.close();
    }

    @Override
    public RutaWordList getWordList(int index, RutaBlock parent) {
        RutaWordList list = this.columnWordLists.get(index);
        if (list == null && index > 0 && index <= this.tableData.get(0).size()) {
            Boolean dictRemoveWS = (Boolean)parent.getContext().getConfigParameterValue("dictRemoveWS");
            if (dictRemoveWS == null) {
                dictRemoveWS = false;
            }
            list = new TreeWordList(this.getColumnData(index - 1), (boolean)dictRemoveWS);
            this.columnWordLists.put(index, list);
        }
        return list;
    }

    private List<String> getColumnData(int i) {
        LinkedList<String> result = new LinkedList<String>();
        for (List<String> each : this.tableData) {
            if (each.size() > i) {
                result.add(each.get(i));
                continue;
            }
            result.add("");
        }
        return result;
    }

    @Override
    public String getEntry(int row, int column) {
        return this.tableData.get(row).get(column);
    }

    @Override
    public List<String> getRowWhere(int column, String lookupValue, boolean ignoreCase) {
        List<String> columnData = this.getColumnData(column);
        int i = 0;
        for (String tableValue : columnData) {
            if (ignoreCase ? tableValue.equalsIgnoreCase(lookupValue) : tableValue.equals(lookupValue)) {
                return this.tableData.get(i);
            }
            ++i;
        }
        i = 0;
        for (String tableValue : columnData) {
            String tableValueWithoutSpacers = tableValue.replaceAll("\\s", "");
            if (ignoreCase ? tableValueWithoutSpacers.equalsIgnoreCase(lookupValue) : tableValueWithoutSpacers.equals(lookupValue)) {
                return this.tableData.get(i);
            }
            ++i;
        }
        return new ArrayList<String>();
    }
}

