/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.number;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.number.AbstractNumberListExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class NumberListFeatureExpression
extends AbstractNumberListExpression {
    private FeatureExpression fe;

    public NumberListFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }

    @Override
    public List<Number> getList(MatchContext context, RutaStream stream) {
        AnnotationFS annotation = context.getAnnotation();
        Feature feature = this.fe.getFeature(context, stream);
        if (feature == null || !feature.getRange().isArray() || !this.validType(feature)) {
            return Collections.emptyList();
        }
        List<AnnotationFS> list = this.getTargetAnnotation(annotation, this.fe, context, stream);
        Collection<? extends FeatureStructure> featureStructures = this.fe.getFeatureStructures(list, false, context, stream);
        ArrayList<Number> result = new ArrayList<Number>();
        for (FeatureStructure featureStructure : featureStructures) {
            Number b;
            int i;
            CommonArrayFS array;
            FeatureStructure featureValue;
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                feature = lazyFeature.initialize(featureStructure);
            }
            if ((featureValue = featureStructure.getFeatureValue(feature)) instanceof IntArrayFS) {
                array = (IntArrayFS)featureValue;
                for (i = 0; i < array.size(); ++i) {
                    b = array.get(i);
                    result.add(b);
                }
                continue;
            }
            if (featureValue instanceof DoubleArrayFS) {
                array = (DoubleArrayFS)featureValue;
                for (i = 0; i < array.size(); ++i) {
                    b = array.get(i);
                    result.add(b);
                }
                continue;
            }
            if (!(featureValue instanceof FloatArrayFS)) continue;
            array = (FloatArrayFS)featureValue;
            for (i = 0; i < array.size(); ++i) {
                b = Float.valueOf(array.get(i));
                result.add(b);
            }
        }
        return result;
    }

    private boolean validType(Feature feature) {
        String name = feature.getRange().getName();
        return StringUtils.equals(name, "uima.cas.IntegerArray") || StringUtils.equals(name, "uima.cas.DoubleArray") || StringUtils.equals(name, "uima.cas.FloatArray");
    }

    public FeatureExpression getFeatureExpression() {
        return this.fe;
    }

    public void setFeatureExpression(FeatureExpression fe) {
        this.fe = fe;
    }
}

