/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.feature.CoveredTextFeature;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.feature.IndexedFeature;
import org.apache.uima.ruta.expression.feature.LazyFeature;
import org.apache.uima.ruta.expression.feature.TypeFeature;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.utils.IndexedReference;
import org.apache.uima.ruta.utils.ParsingUtils;

public class SimpleFeatureExpression
extends FeatureExpression {
    private MatchReference mr;

    public SimpleFeatureExpression(MatchReference mr) {
        this.mr = mr;
    }

    @Override
    public Feature getFeature(MatchContext context, RutaStream stream) {
        List<Feature> features = this.getFeatures(context, stream);
        if (features != null && !features.isEmpty()) {
            Feature feature = features.get(features.size() - 1);
            if (feature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)feature;
                AnnotationFS annotation = context.getAnnotation();
                List<AnnotationFS> targetAnnotation = this.getTargetAnnotation(annotation, this, context, stream);
                if (targetAnnotation != null && !targetAnnotation.isEmpty()) {
                    annotation = targetAnnotation.get(0);
                }
                if (features.size() == 1) {
                    feature = lazyFeature.initialize(annotation);
                }
            }
            return feature;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Feature> getFeatures(MatchContext context, RutaStream stream) {
        ArrayList<Feature> result = new ArrayList<Feature>();
        Type type = this.getInitialType(context, stream);
        Feature feature = null;
        for (String each : this.getFeatureStringList(context, stream)) {
            IndexedReference indexedReference = ParsingUtils.parseIndexedReference(each);
            if (indexedReference.index != -1) {
                Feature delegate = type.getFeatureByBaseName(indexedReference.reference);
                if (delegate == null) throw new IllegalArgumentException("Not able to access feature " + each + " of type " + type.getName() + "in script " + context.getParent().getName());
                feature = new IndexedFeature(delegate, indexedReference.index);
            } else if (StringUtils.equals(each, "coveredText") || StringUtils.equals(each, "ct")) {
                if (type != null) {
                    feature = type.getFeatureByBaseName(each);
                    if (feature == null) {
                        feature = new CoveredTextFeature();
                    }
                } else {
                    feature = new CoveredTextFeature();
                }
            } else if (StringUtils.equals(each, "type")) {
                feature = new TypeFeature();
            } else if (type == null || type.isArray()) {
                feature = new LazyFeature(each, context.getParent());
            } else {
                feature = type.getFeatureByBaseName(each);
                if (feature == null) {
                    feature = new LazyFeature(each, context.getParent());
                }
            }
            result.add(feature);
            if (feature instanceof LazyFeature) {
                type = null;
                continue;
            }
            if (feature == null) continue;
            type = feature.getRange();
        }
        return result;
    }

    @Override
    public Type getInitialType(MatchContext context, RutaStream stream) {
        AnnotationFS annotation;
        ITypeExpression typeExpression = this.mr.getTypeExpression(context, stream);
        IAnnotationExpression annotationExpression = this.mr.getAnnotationExpression(context, stream);
        IAnnotationExpression annotationListExpression = this.mr.getAnnotationExpression(context, stream);
        if (typeExpression != null) {
            return typeExpression.getType(context, stream);
        }
        if (annotationExpression != null) {
            AnnotationFS annotation2 = annotationExpression.getAnnotation(context, stream);
            if (annotation2 != null) {
                return annotation2.getType();
            }
        } else if (annotationListExpression != null && (annotation = annotationListExpression.getAnnotation(context, stream)) != null) {
            return annotation.getType();
        }
        return null;
    }

    @Override
    public List<String> getFeatureStringList(MatchContext context, RutaStream stream) {
        return this.mr.getFeatureList();
    }

    @Override
    public Collection<? extends AnnotationFS> getAnnotations(Collection<? extends FeatureStructure> featureStructures, boolean checkOnFeatureValue, MatchContext context, RutaStream stream) {
        ArrayList result = new ArrayList();
        List<Feature> features = this.getFeatures(context, stream);
        if (features != null && !features.isEmpty()) {
            this.collectFeatureStructures(featureStructures, features, checkOnFeatureValue, true, result, stream, context);
            return result;
        }
        return this.filterAnnotations(featureStructures);
    }

    @Override
    public Collection<? extends FeatureStructure> getFeatureStructures(Collection<? extends FeatureStructure> featureStructures, boolean checkOnFeatureValue, MatchContext context, RutaStream stream) {
        ArrayList result = new ArrayList();
        List<Feature> features = this.getFeatures(context, stream);
        if (features != null && !features.isEmpty()) {
            this.collectFeatureStructures(featureStructures, features, checkOnFeatureValue, false, result, stream, context);
            return result;
        }
        return featureStructures;
    }

    private <T> void collectFeatureStructures(Collection<? extends FeatureStructure> featureStructures, List<Feature> features, boolean checkOnFeatureValue, boolean onlyAnnotations, Collection<T> result, RutaStream stream, MatchContext context) {
        for (FeatureStructure featureStructure : featureStructures) {
            this.collectFeatureStructures(featureStructure, features, checkOnFeatureValue, onlyAnnotations, null, result, stream, context);
        }
    }

    private <T> void collectFeatureStructures(FeatureStructure featureStructure, List<Feature> features, boolean checkOnFeatureValue, boolean collectOnlyAnnotations, T lastValidFeatureStructure, Collection<T> result, RutaStream stream, MatchContext context) {
        if (featureStructure == null) {
            return;
        }
        if (!collectOnlyAnnotations) {
            if (!featureStructure.getType().isArray()) {
                lastValidFeatureStructure = featureStructure;
            }
        } else if (featureStructure instanceof AnnotationFS) {
            lastValidFeatureStructure = featureStructure;
        }
        Feature currentFeature = null;
        List<Feature> tail = null;
        if (features != null && !features.isEmpty()) {
            currentFeature = features.get(0);
            if (currentFeature instanceof LazyFeature) {
                LazyFeature lazyFeature = (LazyFeature)currentFeature;
                Feature delegate = lazyFeature.initialize(featureStructure);
                if (delegate == null) {
                    throw new RuntimeException("Invalid feature! Feature '" + lazyFeature.getFeatureName() + "' is not defined for type '" + featureStructure.getType() + "' in script " + context.getParent().getName() + ".");
                }
                currentFeature = delegate;
            }
            tail = features.subList(1, features.size());
        }
        if (currentFeature == null || currentFeature instanceof CoveredTextFeature || currentFeature instanceof TypeFeature || currentFeature.getRange().isPrimitive()) {
            if (this instanceof FeatureMatchExpression) {
                FeatureMatchExpression fme = (FeatureMatchExpression)this;
                if (checkOnFeatureValue) {
                    if (fme.checkFeatureValue(featureStructure, currentFeature, context, stream)) {
                        result.add(lastValidFeatureStructure);
                    }
                } else {
                    result.add(lastValidFeatureStructure);
                }
            } else {
                result.add(lastValidFeatureStructure);
            }
        } else {
            this.collectFeatureStructures(featureStructure, currentFeature, tail, checkOnFeatureValue, collectOnlyAnnotations, lastValidFeatureStructure, result, stream, context);
        }
    }

    private <T> void collectFeatureStructures(FeatureStructure featureStructure, Feature currentFeature, List<Feature> tail, boolean checkOnFeatureValue, boolean collectOnlyAnnotations, T lastValidFeatureStructure, Collection<T> result, RutaStream stream, MatchContext context) {
        FeatureStructure value;
        if (this instanceof FeatureMatchExpression && (tail == null || tail.isEmpty())) {
            FeatureMatchExpression fme = (FeatureMatchExpression)this;
            if (checkOnFeatureValue) {
                if (fme.checkFeatureValue(featureStructure, currentFeature, context, stream)) {
                    result.add(lastValidFeatureStructure);
                }
            } else {
                result.add(lastValidFeatureStructure);
            }
            return;
        }
        int index = -1;
        if (currentFeature instanceof IndexedFeature) {
            IndexedFeature indexedFeature = (IndexedFeature)currentFeature;
            currentFeature = indexedFeature.getDelegate();
            index = indexedFeature.getIndex();
        }
        if ((value = featureStructure.getFeatureValue(currentFeature)) instanceof AnnotationFS) {
            AnnotationFS next = (AnnotationFS)value;
            this.collectFeatureStructures(next, tail, checkOnFeatureValue, collectOnlyAnnotations, lastValidFeatureStructure, result, stream, context);
        } else if (value instanceof FSArray && index >= 0) {
            FeatureStructure fs;
            FSArray array = (FSArray)value;
            if (index < array.size() && (fs = array.get(index)) instanceof AnnotationFS) {
                AnnotationFS next = (AnnotationFS)fs;
                this.collectFeatureStructures(next, tail, checkOnFeatureValue, collectOnlyAnnotations, lastValidFeatureStructure, result, stream, context);
            }
        } else if (value instanceof FSArray) {
            FSArray array = (FSArray)value;
            for (int i = 0; i < array.size(); ++i) {
                FeatureStructure fs = array.get(i);
                this.collectFeatureStructures(fs, tail, checkOnFeatureValue, collectOnlyAnnotations, lastValidFeatureStructure, result, stream, context);
            }
        } else if (value != null && !value.getType().isPrimitive()) {
            this.collectFeatureStructures(value, tail, checkOnFeatureValue, collectOnlyAnnotations, lastValidFeatureStructure, result, stream, context);
        } else if (value != null) {
            result.add(lastValidFeatureStructure);
        }
    }

    public MatchReference getMatchReference() {
        return this.mr;
    }

    public String toString() {
        return this.mr.getMatch();
    }

    private Collection<AnnotationFS> filterAnnotations(Collection<? extends FeatureStructure> featureStructures) {
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>(featureStructures.size());
        for (FeatureStructure featureStructure : featureStructures) {
            if (!(featureStructure instanceof AnnotationFS)) continue;
            result.add((AnnotationFS)featureStructure);
        }
        return result;
    }
}

