/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.feature;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.block.RutaBlock;

public class LazyFeature
implements Feature {
    private Feature delegate;
    private String featureName;
    private String initializedWith;
    private RutaBlock parent;

    public LazyFeature(String featureName, RutaBlock parent) {
        this.featureName = featureName;
        this.parent = parent;
    }

    public Feature initialize(FeatureStructure featureStructure) {
        return this.initialize(featureStructure.getType());
    }

    public Feature initialize(Type type) {
        if (type == null) {
            return this;
        }
        this.delegate = type.getFeatureByBaseName(this.featureName);
        this.initializedWith = type.getName();
        if (this.delegate == null) {
            return this;
        }
        return this.delegate;
    }

    @Override
    public int compareTo(Feature o) {
        this.checkDelegate();
        return this.delegate.compareTo(o);
    }

    @Override
    public Type getDomain() {
        this.checkDelegate();
        return this.delegate.getDomain();
    }

    @Override
    public Type getRange() {
        this.checkDelegate();
        return this.delegate.getRange();
    }

    @Override
    public String getName() {
        this.checkDelegate();
        return this.delegate.getName();
    }

    @Override
    public String getShortName() {
        this.checkDelegate();
        return this.delegate.getShortName();
    }

    @Override
    public boolean isMultipleReferencesAllowed() {
        this.checkDelegate();
        return this.delegate.isMultipleReferencesAllowed();
    }

    public String getFeatureName() {
        return this.featureName;
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new RuntimeException("Feature with name '" + this.featureName + "' has not yet been resolved in script " + this.parent.getName() + ". Most likely, it is not defined for the given type: " + this.initializedWith);
        }
    }
}

