/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class RutaExpression
extends RutaElement
implements IRutaExpression {
    protected List<AnnotationFS> getTargetAnnotation(AnnotationFS matchedAnnotation, FeatureExpression fe, MatchContext context, RutaStream stream) {
        if (fe instanceof SimpleFeatureExpression) {
            SimpleFeatureExpression sfe = (SimpleFeatureExpression)fe;
            IAnnotationExpression annotationExpression = sfe.getMatchReference().getAnnotationExpression(context, stream);
            IAnnotationListExpression annotationListExpression = sfe.getMatchReference().getAnnotationListExpression(context, stream);
            if (annotationExpression != null) {
                ArrayList<AnnotationFS> as = new ArrayList<AnnotationFS>(1);
                as.add(annotationExpression.getAnnotation(context, stream));
                return as;
            }
            if (annotationListExpression != null) {
                return annotationListExpression.getAnnotationList(context, stream);
            }
        }
        if (matchedAnnotation == null) {
            return Collections.emptyList();
        }
        Type type = fe.getInitialType(context, stream);
        Object documentAnnotation = stream.getCas().getDocumentAnnotation();
        Type docType = documentAnnotation.getType();
        if (docType.equals(type)) {
            ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>(1);
            AnnotationFS windowAnnotation = stream.getFilter().getWindowAnnotation();
            if (windowAnnotation == null) {
                result.add((AnnotationFS)documentAnnotation);
                return result;
            }
            result.add(windowAnnotation);
            return result;
        }
        return stream.getBestGuessedAnnotationsAt(matchedAnnotation, type);
    }
}

