/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;

public class XMIWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT = "Output";
    @ConfigurationParameter(name="Output", mandatory=false, defaultValue={"_InitialView"})
    private String output;
    private UimaContext context;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        if (aContext != null) {
            this.output = (String)aContext.getConfigParameterValue(PARAM_OUTPUT);
            this.context = aContext;
        }
    }

    private static void writeXmi(CAS aCas, File name) throws Exception {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer(out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Iterator sdiit;
        CAS cas = jcas.getCas();
        Type sdiType = cas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
        String filename = "output.txt";
        File file = new File(this.output, filename);
        if (sdiType != null && (sdiit = cas.getAnnotationIndex(sdiType).iterator()).isValid()) {
            Feature uriFeature;
            AnnotationFS annotationFS = (AnnotationFS)sdiit.get();
            String stringValue = annotationFS.getStringValue(uriFeature = sdiType.getFeatureByBaseName("uri"));
            File f = new File(stringValue);
            String name = f.getName();
            if (!name.endsWith(".xmi")) {
                name = name + ".xmi";
            }
            String parent = f.getParent().endsWith("/") ? f.getParent() : f.getParent() + "/";
            file = new File(parent + this.output, name);
        }
        try {
            XMIWriter.writeXmi(cas, file);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
    }
}

