/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasMultiplier_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasCopier;
import org.apache.uima.util.XMLSerializer;

public class ViewWriter
extends JCasMultiplier_ImplBase {
    public static final String PARAM_OUTPUT = "output";
    @ConfigurationParameter(name="output", mandatory=false, defaultValue={""})
    private String output;
    public static final String PARAM_INPUT_VIEW = "inputView";
    @ConfigurationParameter(name="inputView", mandatory=false, defaultValue={"_InitialView"})
    private String inputView;
    public static final String PARAM_OUTPUT_VIEW = "outputView";
    @ConfigurationParameter(name="outputView", mandatory=false, defaultValue={"_InitialView"})
    private String outputView;
    private CAS outView;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.output = (String)aContext.getConfigParameterValue(PARAM_OUTPUT);
        this.inputView = (String)aContext.getConfigParameterValue(PARAM_INPUT_VIEW);
        this.outputView = (String)aContext.getConfigParameterValue(PARAM_OUTPUT_VIEW);
    }

    private static void writeXmi(CAS aCas, File name) throws Exception {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(name);
            XmiCasSerializer ser = new XmiCasSerializer(aCas.getTypeSystem());
            XMLSerializer xmlSer = new XMLSerializer(out, false);
            ser.serialize(aCas, xmlSer.getContentHandler());
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Iterator sdiit;
        CAS cas = jcas.getCas();
        Type sdiType = cas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
        File file = new File(this.output);
        if (file.isDirectory()) {
            String filename = "output.xmi";
            file = new File(this.output, filename);
        }
        if (sdiType != null && (sdiit = cas.getAnnotationIndex(sdiType).iterator()).isValid()) {
            Feature uriFeature;
            AnnotationFS annotationFS = (AnnotationFS)sdiit.get();
            String stringValue = annotationFS.getStringValue(uriFeature = sdiType.getFeatureByBaseName("uri"));
            File f = new File(stringValue);
            String name = f.getName();
            if (!name.endsWith(".xmi")) {
                name = name + ".xmi";
            }
            String parent = f.getParent().endsWith("/") ? f.getParent() : f.getParent() + "/";
            file = new File(parent + this.output, name);
            file.getParentFile().mkdirs();
        }
        CAS inView = cas.getView(this.inputView);
        if (this.outView == null) {
            this.outView = this.getContext().getEmptyCas(CAS.class);
        }
        this.outView.reset();
        CasCopier cc = new CasCopier(inView, this.outView, true);
        cc.copyCasView(inView, this.outputView, true);
        try {
            ViewWriter.writeXmi(this.outView, file);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void collectionProcessComplete() {
        if (this.outView != null) {
            this.outView.release();
        }
        this.outView = null;
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        return false;
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        return null;
    }
}

