/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.ruta.type.DebugBlockApply;
import org.apache.uima.ruta.type.DebugMatchedRuleMatch;
import org.apache.uima.ruta.type.DebugRuleApply;
import org.apache.uima.ruta.type.DebugRuleMatch;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class Ruta {
    public static void applyRule(JCas jcas, String rule, Object ... configurationData) throws ResourceInitializationException, AnalysisEngineProcessException {
        AnalysisEngine ae = null;
        if (configurationData == null || configurationData.length == 0) {
            ae = AnalysisEngineFactory.createEngine(RutaEngine.class, "rules", rule);
        } else {
            Object[] config = ArrayUtils.addAll(configurationData, "rules", rule);
            ae = AnalysisEngineFactory.createEngine(RutaEngine.class, config);
        }
        ae.process(jcas);
        ae.destroy();
    }

    public static void apply(CAS cas, String script, Map<String, Object> parameters) throws IOException, InvalidXMLException, ResourceInitializationException, ResourceConfigurationException, AnalysisEngineProcessException, URISyntaxException {
        String viewName = cas.getViewName();
        URL aedesc = RutaEngine.class.getResource("BasicEngine.xml");
        AnalysisEngine ae = Ruta.wrapAnalysisEngine(aedesc, viewName, null);
        File scriptFile = File.createTempFile("Ruta", ".ruta");
        scriptFile.deleteOnExit();
        FileUtils.saveString2File(script, scriptFile, "UTF-8");
        ae.setConfigParameterValue("scriptPaths", new String[]{scriptFile.getParentFile().getAbsolutePath()});
        String name = scriptFile.getName().substring(0, scriptFile.getName().length() - 5);
        ae.setConfigParameterValue("mainScript", name);
        if (parameters != null) {
            for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                ae.setConfigParameterValue(parameter.getKey(), parameter.getValue());
            }
        }
        ae.reconfigure();
        ae.process(cas);
        scriptFile.delete();
        ae.destroy();
    }

    public static void apply(CAS cas, String script) throws IOException, InvalidXMLException, ResourceInitializationException, ResourceConfigurationException, AnalysisEngineProcessException, URISyntaxException {
        Ruta.apply(cas, script, null);
    }

    private static List<Annotation> getRuleMatches(JCas jcas) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        Collection<DebugBlockApply> blockApplies = JCasUtil.select(jcas, DebugBlockApply.class);
        for (DebugBlockApply debugBlockApply : blockApplies) {
            Ruta.collectRuleMatches(debugBlockApply, result);
        }
        return result;
    }

    private static int countRuleApplies(JCas jcas) {
        int result = 0;
        Collection<DebugBlockApply> blockApplies = JCasUtil.select(jcas, DebugBlockApply.class);
        for (DebugBlockApply debugBlockApply : blockApplies) {
            result += Ruta.countRuleApplies(debugBlockApply);
        }
        return result;
    }

    private static int countRuleApplies(Annotation annotation) {
        int result = 0;
        if (annotation instanceof DebugBlockApply) {
            DebugBlockApply dba = (DebugBlockApply)annotation;
            FSArray innerApply = dba.getInnerApply();
            for (int i = 0; i < innerApply.size(); ++i) {
                Annotation each = (Annotation)innerApply.get(i);
                result += Ruta.countRuleApplies(each);
            }
        } else if (annotation instanceof DebugRuleApply) {
            DebugRuleApply dra = (DebugRuleApply)annotation;
            result += dra.getApplied();
        }
        return result;
    }

    private static void collectRuleMatches(Annotation annotation, List<Annotation> result) {
        if (annotation instanceof DebugBlockApply) {
            DebugBlockApply dba = (DebugBlockApply)annotation;
            FSArray innerApply = dba.getInnerApply();
            for (int i = 0; i < innerApply.size(); ++i) {
                Annotation each = (Annotation)innerApply.get(i);
                Ruta.collectRuleMatches(each, result);
            }
        } else if (annotation instanceof DebugRuleApply) {
            DebugRuleApply dra = (DebugRuleApply)annotation;
            FSArray rules = dra.getRules();
            for (int i = 0; i < rules.size(); ++i) {
                Annotation each = (Annotation)rules.get(i);
                Ruta.collectRuleMatches(each, result);
            }
        } else if (annotation instanceof DebugMatchedRuleMatch) {
            DebugMatchedRuleMatch dmrm = (DebugMatchedRuleMatch)annotation;
            result.add(dmrm);
        }
    }

    public static void removeDebugInformation(JCas jcas) {
        jcas.removeAllIncludingSubtypes(DebugBlockApply.type);
        jcas.removeAllIncludingSubtypes(DebugRuleApply.type);
        jcas.removeAllIncludingSubtypes(DebugRuleMatch.type);
    }

    public static String inject(String script, String placeholder, int[] addresses) {
        String quote = Pattern.quote(placeholder);
        Pattern pattern = Pattern.compile(quote);
        Matcher matcher = pattern.matcher(script);
        StringBuilder sb = new StringBuilder();
        int start = 0;
        int counter = 0;
        while (matcher.find(start)) {
            String group = matcher.group();
            sb.append(script.substring(start, matcher.start()));
            if (counter < addresses.length) {
                sb.append("$" + addresses[0]);
            } else {
                sb.append("$" + group);
            }
            start = matcher.end();
        }
        if (start < script.length()) {
            sb.append(script.substring(start, script.length()));
        }
        return sb.toString();
    }

    public static String inject(String script, FeatureStructureImpl ... annotations) {
        return Ruta.inject(script, "$", Ruta.getAddresses(annotations));
    }

    private static int[] getAddresses(FeatureStructureImpl[] annotations) {
        int[] result = new int[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i].getAddress();
        }
        return result;
    }

    public static List<Annotation> select(JCas jcas, String rule, Object ... configurationData) throws AnalysisEngineProcessException, ResourceInitializationException {
        Object[] config = ArrayUtils.addAll(configurationData, "debug", true, "debugWithMatches", true);
        Ruta.applyRule(jcas, rule, config);
        List<Annotation> ruleMatches = Ruta.getRuleMatches(jcas);
        Ruta.removeDebugInformation(jcas);
        return ruleMatches;
    }

    public static boolean matches(JCas jcas, String rule, Object ... configurationData) throws AnalysisEngineProcessException, ResourceInitializationException {
        Object[] config = ArrayUtils.addAll(configurationData, "debug", true);
        Ruta.applyRule(jcas, rule, config);
        int applies = Ruta.countRuleApplies(jcas);
        Ruta.removeDebugInformation(jcas);
        return applies > 0;
    }

    public static AnalysisEngine wrapAnalysisEngine(URL descriptorUrl, String viewName, ResourceManager resourceManager) throws ResourceInitializationException, ResourceConfigurationException, InvalidXMLException, IOException, URISyntaxException {
        return Ruta.wrapAnalysisEngine(descriptorUrl, viewName, false, Charset.defaultCharset().name(), resourceManager);
    }

    public static AnalysisEngine wrapAnalysisEngine(URL descriptorUrl, String viewName, boolean rutaEngine, String encoding, ResourceManager resourceManager) throws ResourceInitializationException, ResourceConfigurationException, InvalidXMLException, IOException, URISyntaxException {
        if (viewName.equals("_InitialView")) {
            XMLInputSource in = new XMLInputSource(descriptorUrl);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(specifier, resourceManager, null);
            return ae;
        }
        InputStream inputStream = null;
        inputStream = rutaEngine ? Ruta.class.getResourceAsStream("AAEDBasicEngine.xml") : Ruta.class.getResourceAsStream("AAED.xml");
        String aaedString = IOUtils.toString(inputStream, encoding);
        String absolutePath = descriptorUrl.toExternalForm();
        aaedString = aaedString.replaceAll("\\$\\{sofaName\\}", viewName);
        aaedString = aaedString.replaceAll("\\$\\{descriptorLocation\\}", absolutePath);
        File tempFile = File.createTempFile("RutaAAED", ".xml");
        FileUtils.saveString2File(aaedString, tempFile);
        XMLInputSource in = new XMLInputSource(tempFile);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(specifier, resourceManager, null);
        tempFile.delete();
        return ae;
    }

    @Deprecated
    public static AnalysisEngineDescription createAnalysisEngineDescription(String script) throws IOException, InvalidXMLException, ResourceInitializationException {
        return Ruta.createAnalysisEngineDescription(script, null);
    }

    @Deprecated
    public static AnalysisEngineDescription createAnalysisEngineDescription(String script, TypeSystemDescription ... tsds) throws IOException, InvalidXMLException, ResourceInitializationException {
        File scriptFile = File.createTempFile("Ruta", ".ruta");
        scriptFile.deleteOnExit();
        if (!script.startsWith("PACKAGE")) {
            script = "PACKAGE org.apache.uima.ruta;\n" + script;
        }
        FileUtils.saveString2File(script, scriptFile);
        URL url = RutaEngine.class.getResource("BasicEngine.xml");
        XMLInputSource in = new XMLInputSource(url);
        AnalysisEngineDescription aed = (AnalysisEngineDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngineMetaData metaData = aed.getAnalysisEngineMetaData();
        ConfigurationParameterSettings settings = metaData.getConfigurationParameterSettings();
        settings.setParameterValue("scriptPaths", new String[]{scriptFile.getParentFile().getAbsolutePath()});
        String name = scriptFile.getName().substring(0, scriptFile.getName().length() - 5);
        settings.setParameterValue("mainScript", name);
        if (tsds != null) {
            ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
            tsdList.add(metaData.getTypeSystem());
            tsdList.addAll(Arrays.asList(tsds));
            TypeSystemDescription typeSystemDescription = CasCreationUtils.mergeTypeSystems(tsdList);
            metaData.setTypeSystem(typeSystemDescription);
        }
        return aed;
    }
}

