/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.htmlparser.Attribute;
import org.htmlparser.Node;
import org.htmlparser.Remark;
import org.htmlparser.Tag;
import org.htmlparser.visitors.NodeVisitor;

public class HtmlVisitor
extends NodeVisitor {
    private CAS cas;
    private List<AnnotationFS> annotations = new ArrayList<AnnotationFS>();
    private LinkedList<AnnotationFS> annotationStack = new LinkedList();
    private JCas jcas;
    private boolean onlyContent;

    public HtmlVisitor(JCas jcas, boolean onlyContent) {
        this.jcas = jcas;
        this.cas = jcas.getCas();
        this.onlyContent = onlyContent;
    }

    @Override
    public void visitTag(Tag tag) {
        int begin;
        String name = this.getName(tag);
        Type type = this.getType(name, this.cas);
        boolean tagClosed = this.isTagClosed(tag);
        boolean tagStillOpen = false;
        int end = begin = this.getBeginOffset(tag);
        if (tagClosed) {
            end = this.getEndOffset(tag);
        } else {
            Tag endTag = tag.getEndTag();
            if (endTag != null) {
                end = this.getEndOffset(endTag);
            } else {
                end = this.getEndOffset(tag);
                tagStillOpen = true;
            }
        }
        AnnotationFS annotation = this.cas.createAnnotation(type, begin, end);
        this.processAttributes(annotation, tag);
        Feature nameFeature = annotation.getType().getFeatureByBaseName("name");
        annotation.setStringValue(nameFeature, name);
        if (tagStillOpen) {
            this.annotationStack.add(annotation);
        } else {
            this.annotations.add(annotation);
        }
    }

    @Override
    public void visitRemarkNode(Remark node) {
        Type type = this.getType("REMARK", this.cas);
        int begin = this.getBeginOffset(node);
        int end = this.getEndOffset(node);
        AnnotationFS annotation = this.cas.createAnnotation(type, begin, end);
        Feature feature = type.getFeatureByBaseName("comment");
        annotation.setStringValue(feature, node.getText());
        this.annotations.add(annotation);
    }

    @Override
    public void visitEndTag(Tag tag) {
        String name = this.getName(tag);
        AnnotationFS found = null;
        for (int i = this.annotationStack.size() - 1; i >= 0; --i) {
            Feature nameFeature;
            AnnotationFS each = this.annotationStack.get(i);
            String eachName = each.getStringValue(nameFeature = each.getType().getFeatureByBaseName("name"));
            if (!name.equals(eachName)) continue;
            int endOffset = this.getEndOffset(tag);
            Feature endFeature = each.getType().getFeatureByBaseName("end");
            each.setIntValue(endFeature, endOffset);
            found = each;
            break;
        }
        if (found != null) {
            this.annotationStack.remove(found);
            this.annotations.add(found);
        }
    }

    private boolean isTagClosed(Tag tag) {
        return tag.getRawTagName().endsWith("/");
    }

    private String getName(Tag tag) {
        String result = tag.getRawTagName().toUpperCase();
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith("/")) {
            result = result.substring(1);
        }
        return result;
    }

    private Type getType(String name, CAS cas) {
        String typeName = "org.apache.uima.ruta.type.html." + name;
        Type type = cas.getTypeSystem().getType(typeName);
        if (type == null) {
            type = cas.getTypeSystem().getType("org.apache.uima.ruta.type.html.TAG");
        }
        return type;
    }

    private int getBeginOffset(Node tag) {
        if (this.onlyContent) {
            return tag.getEndPosition();
        }
        return tag.getStartPosition();
    }

    private int getEndOffset(Node tag) {
        if (this.onlyContent) {
            return tag.getStartPosition();
        }
        return tag.getEndPosition();
    }

    private void processAttributes(AnnotationFS annotation, Tag tag) {
        int size = tag.getAttributesEx().size() - 1;
        StringArray attributeName = new StringArray(this.jcas, size);
        StringArray attributeValue = new StringArray(this.jcas, size);
        for (int i = 0; i < size; ++i) {
            Attribute attribute = (Attribute)tag.getAttributesEx().elementAt(i + 1);
            attributeName.set(i, attribute.getName());
            attributeValue.set(i, attribute.getValue());
        }
        Feature feature1 = annotation.getType().getFeatureByBaseName("attributeName");
        annotation.setFeatureValue(feature1, attributeName);
        Feature feature2 = annotation.getType().getFeatureByBaseName("attributeValue");
        annotation.setFeatureValue(feature2, attributeValue);
    }

    public List<AnnotationFS> getAnnotations() {
        return this.annotations;
    }

    public LinkedList<AnnotationFS> getAnnotationStack() {
        return this.annotationStack;
    }
}

