/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.HtmlVisitor;
import org.htmlparser.Parser;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;

public class HtmlAnnotator
extends JCasAnnotator_ImplBase {
    public static final String NAMESPACE = "org.apache.uima.ruta.type.html.";
    public static final String PARAM_ONLY_CONTENT = "onlyContent";
    @ConfigurationParameter(name="onlyContent", mandatory=false, defaultValue={"true"})
    private Boolean onlyContent;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.onlyContent = (Boolean)aContext.getConfigParameterValue(PARAM_ONLY_CONTENT);
        this.onlyContent = this.onlyContent == null ? true : this.onlyContent;
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String documentText = jcas.getDocumentText();
        List<Object> annotations = new ArrayList();
        AbstractList annotationStack = new ArrayList();
        try {
            Parser parser2 = new Parser(documentText);
            NodeList nodeList = parser2.parse(null);
            HtmlVisitor visitor = new HtmlVisitor(jcas, (boolean)this.onlyContent);
            nodeList.visitAllNodesWith(visitor);
            annotations = visitor.getAnnotations();
            annotationStack = visitor.getAnnotationStack();
        }
        catch (ParserException e) {
            throw new AnalysisEngineProcessException(e);
        }
        for (AnnotationFS annotationFS : annotations) {
            if (annotationFS.getBegin() >= annotationFS.getEnd()) continue;
            jcas.addFsToIndexes(annotationFS);
        }
        for (AnnotationFS annotationFS : annotationStack) {
            if (annotationFS.getBegin() >= annotationFS.getEnd()) continue;
            jcas.addFsToIndexes(annotationFS);
        }
    }
}

