/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;

public class AnnotationWriter
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT = "Output";
    @ConfigurationParameter(name="Output", mandatory=false, defaultValue={"/../output/"})
    private String output;
    public static final String PARAM_ENCODING = "Encoding";
    @ConfigurationParameter(name="Encoding", mandatory=false, defaultValue={"UTF-8"})
    private String encoding;
    public static final String PARAM_TYPE = "Type";
    @ConfigurationParameter(name="Type", mandatory=false, defaultValue={">uima.tcas.DocumentAnnotation"})
    private String type;
    private UimaContext context;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        if (aContext != null) {
            this.output = (String)aContext.getConfigParameterValue(PARAM_OUTPUT);
            this.type = (String)aContext.getConfigParameterValue(PARAM_TYPE);
            this.encoding = (String)aContext.getConfigParameterValue(PARAM_ENCODING);
            this.context = aContext;
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        Iterator sdiit;
        CAS cas = jcas.getCas();
        Type targetType = cas.getTypeSystem().getType(this.type);
        Iterator iterator = cas.getAnnotationIndex(targetType).iterator();
        StringBuilder newDocument = new StringBuilder();
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            newDocument.append(fs.getCoveredText());
            newDocument.append("\n");
            iterator.moveToNext();
        }
        Type sdiType = cas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
        String filename = "output.txt";
        File file = new File(this.output, filename);
        if (sdiType != null && (sdiit = cas.getAnnotationIndex(sdiType).iterator()).isValid()) {
            Feature uriFeature;
            AnnotationFS annotationFS = (AnnotationFS)sdiit.get();
            String stringValue = annotationFS.getStringValue(uriFeature = sdiType.getFeatureByBaseName("uri"));
            File f = new File(stringValue);
            String name = f.getName();
            if (!name.endsWith(".txt")) {
                name = name + ".txt";
            }
            file = new File(f.getParent() + this.output, name);
        }
        try {
            FileUtils.saveString2File(newDocument.toString(), file, this.encoding);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }
}

