/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class VoteCondition
extends TerminalRutaCondition {
    private final ITypeExpression type1;
    private final ITypeExpression type2;

    public VoteCondition(ITypeExpression type1, ITypeExpression type2) {
        this.type1 = type1;
        this.type2 = type2;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        int count1 = 0;
        int count2 = 0;
        Type t1 = this.type1.getType(context, stream);
        Type t2 = this.type2.getType(context, stream);
        if (annotation != null && t1 != null && t2 != null) {
            List<RutaBasic> annotations = stream.getBasicsInWindow(annotation);
            for (RutaBasic each : annotations) {
                if (each.beginsWith(t1)) {
                    ++count1;
                }
                if (!each.beginsWith(t2)) continue;
                ++count2;
            }
        }
        return new EvaluatedCondition(this, count1 > count2);
    }

    public ITypeExpression getType1() {
        return this.type1;
    }

    public ITypeExpression getType2() {
        return this.type2;
    }
}

