/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class SizeCondition
extends AbstractRutaCondition {
    private ListExpression<?> listExpr;
    private INumberExpression minExpr;
    private INumberExpression maxExpr;
    private String varExpr;

    public SizeCondition(ListExpression<?> list, INumberExpression min2, INumberExpression max, String string) {
        this.listExpr = list;
        this.minExpr = min2 == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min2;
        this.maxExpr = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.varExpr = string;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        boolean value;
        RuleElement element = context.getElement();
        int count = this.listExpr.getList(context, stream).size();
        boolean bl = value = count >= this.minExpr.getIntegerValue(context, stream) && count <= this.maxExpr.getIntegerValue(context, stream);
        if (this.varExpr != null) {
            element.getParent().getEnvironment().setVariableValue(this.varExpr, count);
        }
        return new EvaluatedCondition(this, value);
    }

    public ListExpression<?> getListExpr() {
        return this.listExpr;
    }

    public INumberExpression getMinExpr() {
        return this.minExpr;
    }

    public INumberExpression getMaxExpr() {
        return this.maxExpr;
    }

    public String getVarExpr() {
        return this.varExpr;
    }
}

