/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaAnnotation;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ScoreCondition
extends TerminalRutaCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final String var;

    public ScoreCondition(INumberExpression min2, INumberExpression max, String var) {
        this.min = min2 == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min2;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        RuleElement element = context.getElement();
        double score = 0.0;
        RutaAnnotation rutaAnnotation = stream.getRutaAnnotationFor(annotation, false, stream);
        if (rutaAnnotation != null) {
            score = rutaAnnotation.getScore();
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, score);
        }
        boolean value = score >= this.min.getDoubleValue(context, stream) && score <= this.max.getDoubleValue(context, stream);
        return new EvaluatedCondition(this, value);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

