/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TerminalRutaCondition;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RegExpCondition
extends TerminalRutaCondition {
    private final IStringExpression pattern;
    private final IBooleanExpression ignoreCase;
    private IStringExpression variable;

    public RegExpCondition(IStringExpression pattern, IBooleanExpression ignoreCase) {
        this.pattern = pattern;
        this.ignoreCase = ignoreCase == null ? new SimpleBooleanExpression(false) : ignoreCase;
    }

    public RegExpCondition(IStringExpression v, IStringExpression pattern, IBooleanExpression ignoreCase) {
        this(pattern, ignoreCase);
        this.variable = v;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (annotation == null) {
            return new EvaluatedCondition(this, false);
        }
        Matcher matcher = null;
        boolean ignore = this.ignoreCase == null ? false : this.ignoreCase.getBooleanValue(context, stream);
        String stringValue = this.pattern.getStringValue(context, stream);
        if (stringValue == null) {
            return new EvaluatedCondition(this, false);
        }
        if (this.variable == null) {
            String coveredText = annotation.getCoveredText();
            Pattern regularExpPattern = null;
            regularExpPattern = ignore ? Pattern.compile(stringValue, 106) : Pattern.compile(stringValue, 40);
            matcher = regularExpPattern.matcher(coveredText);
        } else {
            String variableValue = this.variable.getStringValue(context, stream);
            if (variableValue == null) {
                return new EvaluatedCondition(this, false);
            }
            Pattern regularExpPattern = null;
            regularExpPattern = ignore ? Pattern.compile(stringValue, 106) : Pattern.compile(stringValue, 40);
            matcher = regularExpPattern.matcher(variableValue);
        }
        boolean matches = matcher.matches();
        return new EvaluatedCondition(this, matches);
    }

    public IStringExpression getPattern() {
        return this.pattern;
    }

    public IStringExpression getVariable() {
        return this.variable;
    }

    public IBooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }
}

