/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class PartOfNeqCondition
extends TypeSentiveCondition {
    public PartOfNeqCondition(ITypeExpression type) {
        super(type);
    }

    public PartOfNeqCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Type t;
        AnnotationFS annotation = context.getAnnotation();
        if (!this.isWorkingOnList()) {
            Type t2 = this.type.getType(context, stream);
            boolean result = this.check(annotation, stream, t2);
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        Iterator iterator = types.iterator();
        while (iterator.hasNext() && !(result |= this.check(annotation, stream, t = (Type)iterator.next()))) {
        }
        return new EvaluatedCondition(this, result);
    }

    private boolean check(AnnotationFS annotation, RutaStream stream, Type t) {
        boolean partOf;
        if (annotation == null || t == null) {
            return false;
        }
        RutaBasic beginAnchor = stream.getBeginAnchor(annotation.getBegin());
        RutaBasic endAnchor = stream.getEndAnchor(annotation.getEnd());
        boolean bl = partOf = beginAnchor.isPartOf(t) || endAnchor.isPartOf(t);
        if (!partOf) {
            return false;
        }
        try {
            stream.moveTo(annotation);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (stream.isValid()) {
            RutaBasic each = (RutaBasic)stream.get();
            Collection<AnnotationFS> set = each.getBeginAnchors(t);
            if (set == null) {
                stream.moveToPrevious();
                continue;
            }
            for (AnnotationFS afs : set) {
                if (afs == null || !afs.getType().equals(t) && !stream.getCas().getTypeSystem().subsumes(t, afs.getType()) || !(afs.getBegin() < annotation.getBegin() && afs.getEnd() > annotation.getEnd() || afs.getBegin() == annotation.getBegin() && afs.getEnd() > annotation.getEnd()) && (afs.getBegin() >= annotation.getBegin() || afs.getEnd() != annotation.getEnd())) continue;
                return true;
            }
            stream.moveToPrevious();
        }
        return false;
    }
}

