/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class NearCondition
extends TypeSentiveCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final IBooleanExpression forward;
    private final IBooleanExpression filtered;

    public NearCondition(ITypeExpression type, INumberExpression min2, INumberExpression max, IBooleanExpression forward, IBooleanExpression filtered) {
        super(type);
        this.min = min2 == null ? new SimpleNumberExpression(1) : min2;
        this.max = max == null ? new SimpleNumberExpression(1) : max;
        this.forward = forward == null ? new SimpleBooleanExpression(true) : forward;
        this.filtered = filtered == null ? new SimpleBooleanExpression(false) : filtered;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        Type t = this.type.getType(context, stream);
        if (annotation == null || t == null) {
            return new EvaluatedCondition(this, false);
        }
        int maxValue = this.max.getIntegerValue(context, stream);
        int minValue = this.min.getIntegerValue(context, stream);
        boolean forwardValue = this.forward.getBooleanValue(context, stream);
        FSIterator<AnnotationFS> it = this.filtered.getBooleanValue(context, stream) ? stream : stream.getUnfilteredBasicIterator();
        RutaBasic pointer = null;
        pointer = forwardValue ? stream.getEndAnchor(annotation.getEnd()) : stream.getBeginAnchor(annotation.getBegin());
        it.moveTo(pointer);
        for (int count = 0; count <= maxValue; ++count) {
            RutaBasic each;
            AnnotationFS featureStructure;
            if (count >= minValue && it.isValid() && (featureStructure = it.get()) instanceof RutaBasic && (each = (RutaBasic)featureStructure).isPartOf(t)) {
                return new EvaluatedCondition(this, true);
            }
            if (forwardValue) {
                it.moveToNext();
                continue;
            }
            it.moveToPrevious();
        }
        return new EvaluatedCondition(this, false);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public IBooleanExpression getForward() {
        return this.forward;
    }

    public IBooleanExpression getFiltered() {
        return this.filtered;
    }
}

