/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.feature.FeatureMatchExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ImplicitCondition
extends AbstractRutaCondition {
    private IRutaExpression expr;

    public ImplicitCondition(IRutaExpression expr) {
        this.expr = expr;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        if (this.expr instanceof IBooleanExpression) {
            IBooleanExpression be = (IBooleanExpression)this.expr;
            return new EvaluatedCondition(this, be.getBooleanValue(context, stream));
        }
        if (this.expr instanceof FeatureMatchExpression) {
            FeatureMatchExpression fme = (FeatureMatchExpression)this.expr;
            List<AnnotationFS> annotations = new ArrayList<AnnotationFS>();
            MatchReference matchReference = fme.getMatchReference();
            ITypeExpression typeExpr = matchReference.getTypeExpression(context, stream);
            IAnnotationListExpression annotationListExpr = matchReference.getAnnotationListExpression(context, stream);
            IAnnotationExpression annotationExpr = matchReference.getAnnotationExpression(context, stream);
            if (typeExpr != null) {
                Type type = typeExpr.getType(context, stream);
                annotations = this.getAnnotationsToCheck(annotation, type, fme, stream);
            } else if (annotationListExpr != null) {
                annotations.addAll(annotationListExpr.getAnnotationList(context, stream));
            } else if (annotationExpr != null) {
                annotations.add(annotationExpr.getAnnotation(context, stream));
            }
            Collection<? extends FeatureStructure> featureAnnotations = fme.getFeatureStructures(annotations, true, context, stream);
            return new EvaluatedCondition(this, !featureAnnotations.isEmpty());
        }
        return new EvaluatedCondition(this, false);
    }

    private List<AnnotationFS> getAnnotationsToCheck(AnnotationFS annotation, Type type, FeatureMatchExpression fme, RutaStream stream) {
        if (annotation == null || type == null) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationFS> result = new ArrayList<AnnotationFS>();
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        if (typeSystem.subsumes(type, annotation.getType())) {
            result.add(annotation);
        } else {
            Collection<AnnotationFS> beginAnchors = stream.getBeginAnchor(annotation.getBegin()).getBeginAnchors(type);
            Collection<AnnotationFS> endAnchors = stream.getEndAnchor(annotation.getEnd()).getEndAnchors(type);
            Collection intersection = CollectionUtils.intersection(beginAnchors, endAnchors);
            result.addAll(intersection);
        }
        return result;
    }

    public IRutaExpression getExpr() {
        return this.expr;
    }

    public void setExpr(IRutaExpression expr) {
        this.expr = expr;
    }
}

