/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ContextCountCondition
extends TypeSentiveCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final String var;

    public ContextCountCondition(ITypeExpression type, INumberExpression min2, INumberExpression max, String var) {
        super(type);
        this.min = min2 == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min2;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        RuleElement element = context.getElement();
        Type contextType = this.type.getType(context, stream);
        if (contextType == null) {
            return new EvaluatedCondition(this, false);
        }
        stream.moveToFirst();
        ArrayList<AnnotationFS> visibleContexts = new ArrayList<AnnotationFS>();
        while (stream.isValid()) {
            RutaBasic each = (RutaBasic)stream.get();
            if (each.beginsWith(contextType)) {
                visibleContexts.addAll(each.getBeginAnchors(contextType));
            }
            stream.moveToNext();
        }
        ArrayList<AnnotationFS> overlappingContexts = new ArrayList<AnnotationFS>();
        for (AnnotationFS eachContext : visibleContexts) {
            if (annotation == null || eachContext.getBegin() > annotation.getBegin() || eachContext.getEnd() < annotation.getEnd()) continue;
            overlappingContexts.add(eachContext);
        }
        boolean result = false;
        for (AnnotationFS eachContext : overlappingContexts) {
            boolean value;
            int index = 0;
            int counter = 0;
            if (annotation != null) {
                List<RutaBasic> basicsInWindow = stream.getBasicsInWindow(eachContext);
                for (RutaBasic eachBasic : basicsInWindow) {
                    Collection<AnnotationFS> beginAnchors = eachBasic.getBeginAnchors(annotation.getType());
                    if (beginAnchors == null) continue;
                    for (AnnotationFS each : beginAnchors) {
                        ++counter;
                        if (each.getBegin() != annotation.getBegin() || each.getEnd() != annotation.getEnd() || !each.getType().equals(annotation.getType()) && !stream.getCas().getTypeSystem().subsumes(annotation.getType(), each.getType())) continue;
                        index = counter;
                    }
                }
            }
            if (this.var != null) {
                element.getParent().getEnvironment().setVariableValue(this.var, index);
            }
            if (!(result |= (value = index >= this.min.getIntegerValue(context, stream) && index <= this.max.getIntegerValue(context, stream)))) continue;
            break;
        }
        return new EvaluatedCondition(this, result);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

