/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class AfterCondition
extends TypeSentiveCondition {
    public AfterCondition(ITypeExpression type) {
        super(type);
    }

    public AfterCondition(AbstractTypeListExpression list) {
        super(list);
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Type t;
        AnnotationFS annotation = context.getAnnotation();
        if (!this.isWorkingOnList()) {
            Type t2 = this.type.getType(context, stream);
            boolean result = this.check(annotation, stream, t2);
            return new EvaluatedCondition(this, result);
        }
        boolean result = false;
        List types = this.getList().getList(context, stream);
        Iterator iterator = types.iterator();
        while (iterator.hasNext() && !(result |= this.check(annotation, stream, t = (Type)iterator.next()))) {
        }
        return new EvaluatedCondition(this, result);
    }

    private boolean check(AnnotationFS annotation, RutaStream stream, Type t) {
        if (annotation == null || t == null) {
            return false;
        }
        boolean result = false;
        FSIterator it = stream.getCas().getAnnotationIndex(t).iterator(annotation);
        if (!it.isValid()) {
            it.moveToLast();
        }
        while (it.isValid()) {
            AnnotationFS a = (AnnotationFS)it.get();
            if (a.getBegin() <= annotation.getBegin()) {
                result = true;
                break;
            }
            it.moveToPrevious();
        }
        return result;
    }
}

