/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class TrimAction
extends AbstractRutaAction {
    private AbstractTypeListExpression typeList;
    private List<ITypeExpression> types;

    public TrimAction(List<ITypeExpression> types, AbstractTypeListExpression typeList) {
        this.types = types;
        this.typeList = typeList;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<AnnotationFS> matchedAnnotationsOf = match.getMatchedAnnotationsOfElement(element);
        List<Type> typesToTrim = this.getTypes(context, stream);
        for (AnnotationFS annotationFS : matchedAnnotationsOf) {
            this.trimAnnotation(annotationFS, typesToTrim, match, stream);
        }
    }

    private void trimAnnotation(AnnotationFS annotation, List<Type> typesToTrim, RuleMatch match, RutaStream stream) {
        int oldBegin = annotation.getBegin();
        int oldEnd = annotation.getEnd();
        int newBegin = oldBegin;
        int newEnd = oldEnd;
        RutaBasic beginBasic = stream.getBeginAnchor(oldBegin);
        while (beginBasic != null && this.isPartof(beginBasic, typesToTrim) && beginBasic.getBegin() < oldEnd) {
            beginBasic = stream.getBasicNextTo(false, beginBasic);
        }
        if (beginBasic == null) {
            stream.removeAnnotation(annotation);
            return;
        }
        newBegin = beginBasic.getBegin();
        RutaBasic endBasic = stream.getEndAnchor(oldEnd);
        while (endBasic != null && this.isPartof(endBasic, typesToTrim) && endBasic.getEnd() > newBegin) {
            endBasic = stream.getBasicNextTo(true, endBasic);
        }
        if (endBasic == null) {
            stream.removeAnnotation(annotation);
            return;
        }
        newEnd = endBasic.getEnd();
        if (oldBegin != newBegin || newEnd != oldEnd) {
            stream.removeAnnotation(annotation);
            if (annotation instanceof Annotation && newBegin < newEnd) {
                Annotation a = (Annotation)annotation;
                a.setBegin(newBegin);
                a.setEnd(newEnd);
                stream.addAnnotation(annotation, true, match);
            }
        }
    }

    private boolean isPartof(RutaBasic basic, List<Type> typesToTrim) {
        for (Type type : typesToTrim) {
            boolean partOf = basic.isPartOf(type);
            if (!partOf) continue;
            return true;
        }
        return false;
    }

    private List<Type> getTypes(MatchContext context, RutaStream stream) {
        List<Type> result = new ArrayList<Type>();
        if (this.types != null) {
            for (ITypeExpression each : this.types) {
                Type type = each.getType(context, stream);
                if (type == null) continue;
                result.add(type);
            }
        } else if (this.typeList != null) {
            result = this.typeList.getList(context, stream);
        }
        return result;
    }

    public AbstractTypeListExpression getTypeList() {
        return this.typeList;
    }

    public List<ITypeExpression> getTypes() {
        return this.types;
    }
}

