/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.UntypedListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class TrieAction
extends AbstractRutaAction {
    private final WordListExpression list;
    private final Map<IStringExpression, IRutaExpression> map;
    private final IBooleanExpression ignoreCase;
    private final INumberExpression ignoreLength;
    private final IBooleanExpression edit;
    private final INumberExpression distance;
    private final IStringExpression ignoreChar;

    public TrieAction(WordListExpression list, Map<IStringExpression, IRutaExpression> map, IBooleanExpression ignoreCase, INumberExpression ignoreLength, IBooleanExpression edit, INumberExpression distance, IStringExpression ignoreChar) {
        this.list = list;
        this.map = map;
        this.ignoreCase = ignoreCase;
        this.ignoreLength = ignoreLength;
        this.edit = edit;
        this.distance = distance;
        this.ignoreChar = ignoreChar;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        Collection<AnnotationFS> found;
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        element.getParent();
        for (IStringExpression eachKey : this.map.keySet()) {
            String stringValue = eachKey.getStringValue(context, stream);
            IRutaExpression expression = this.map.get(eachKey);
            if (expression instanceof ITypeExpression) {
                Type typeValue = ((ITypeExpression)expression).getType(context, stream);
                if (typeValue == null) continue;
                typeMap.put(stringValue, typeValue);
                continue;
            }
            if (!(expression instanceof UntypedListExpression)) continue;
            List<Object> innerList = ((UntypedListExpression)expression).getList(context, stream);
            typeMap.put(stringValue, innerList);
        }
        boolean ignoreCaseValue = this.ignoreCase.getBooleanValue(context, stream);
        int ignoreLengthValue = this.ignoreLength.getIntegerValue(context, stream);
        boolean editValue = this.edit.getBooleanValue(context, stream);
        double distanceValue = this.distance.getDoubleValue(context, stream);
        String ignoreCharValue = this.ignoreChar.getStringValue(context, stream);
        RutaWordList wl = this.list.getList(context, stream);
        if (wl != null && (found = wl.find(stream, typeMap, ignoreCaseValue, ignoreLengthValue, editValue, distanceValue, ignoreCharValue)) != null) {
            for (AnnotationFS annotation : found) {
                stream.addAnnotation(annotation, match);
                stream.getCas().addFsToIndexes(annotation);
            }
        }
    }

    public WordListExpression getList() {
        return this.list;
    }

    public Map<IStringExpression, IRutaExpression> getMap() {
        return this.map;
    }

    public IBooleanExpression getIgnoreCase() {
        return this.ignoreCase;
    }

    public INumberExpression getIgnoreLength() {
        return this.ignoreLength;
    }

    public IBooleanExpression getEdit() {
        return this.edit;
    }

    public INumberExpression getDistance() {
        return this.distance;
    }

    public IStringExpression getIgnoreChar() {
        return this.ignoreChar;
    }
}

