/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.MarkAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.AnnotationComparator;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ShiftAction
extends MarkAction {
    private IBooleanExpression all;

    public ShiftAction(ITypeExpression type, List<INumberExpression> list, IBooleanExpression all) {
        super(type, null, list);
        this.all = all;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        Type targetType = this.type.getType(context, stream);
        if (targetType == null) {
            return;
        }
        List<Integer> indexList = this.getIndexList(context, this.list, stream);
        List<AnnotationFS> destinationAnnotationSpans = match.getMatchedAnnotations(indexList, element.getContainer());
        List<AnnotationFS> annotationsMatchedByRuleElementofAction = match.getMatchedAnnotationsOfElement(element);
        int size = Math.min(annotationsMatchedByRuleElementofAction.size(), destinationAnnotationSpans.size());
        boolean expandAll = this.all == null ? false : this.all.getBooleanValue(context, stream);
        RutaBasic firstBasicOfAll = stream.getFirstBasicOfAll();
        RutaBasic lastBasicOfAll = stream.getLastBasicOfAll();
        int windowBegin = firstBasicOfAll == null ? 0 : firstBasicOfAll.getBegin();
        int windowEnd = lastBasicOfAll == null ? 0 : lastBasicOfAll.getEnd();
        for (int i = 0; i < size; ++i) {
            AnnotationFS eachMatched = annotationsMatchedByRuleElementofAction.get(i);
            AnnotationFS eachDestination = destinationAnnotationSpans.get(i);
            TreeSet<AnnotationFS> allAnchoredAnnotations = new TreeSet<AnnotationFS>(new AnnotationComparator());
            if (expandAll) {
                Collection<AnnotationFS> beginAnchors = stream.getBeginAnchor(eachMatched.getBegin()).getBeginAnchors(targetType);
                Collection<AnnotationFS> endAnchors = stream.getEndAnchor(eachMatched.getEnd()).getEndAnchors(targetType);
                allAnchoredAnnotations.addAll(beginAnchors);
                allAnchoredAnnotations.addAll(endAnchors);
            } else {
                allAnchoredAnnotations.addAll(stream.getBestGuessedAnnotationsAt(eachMatched, targetType));
            }
            for (AnnotationFS eachAnchored : allAnchoredAnnotations) {
                if (eachAnchored.getBegin() < windowBegin || eachAnchored.getEnd() > windowEnd) continue;
                Annotation a = (Annotation)eachAnchored;
                stream.changeOffsets(a, eachDestination.getBegin(), eachDestination.getEnd(), match);
                this.addAnnotationToLabel(a, context);
            }
        }
    }

    public IBooleanExpression getAll() {
        return this.all;
    }
}

