/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RemoveAction
extends AbstractRutaAction {
    private String var;
    private List<IRutaExpression> elements;

    public RemoveAction(String var, List<IRutaExpression> list) {
        this.var = var;
        this.elements = list;
    }

    public String getListExpr() {
        return this.var;
    }

    public List<IRutaExpression> getElements() {
        return this.elements;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        List list = parent.getEnvironment().getVariableValue(this.var, List.class, stream);
        Class<?> vgtype = parent.getEnvironment().getVariableGenericType(this.var);
        ArrayList toRemove = new ArrayList();
        for (Object entry : list) {
            Object value1 = this.getValue(entry, vgtype, context, stream);
            for (IRutaExpression arg : this.elements) {
                if (arg instanceof ListExpression) {
                    ListExpression l = (ListExpression)arg;
                    List list2 = l.getList(context, stream);
                    for (Object object : list2) {
                        Object value2 = this.getValue(object, vgtype, context, stream);
                        if (!value1.equals(value2)) continue;
                        toRemove.add(entry);
                    }
                    continue;
                }
                Object value2 = this.getValue(arg, vgtype, context, stream);
                if (!value1.equals(value2)) continue;
                toRemove.add(entry);
            }
        }
        for (Object object : toRemove) {
            list.remove(object);
        }
        parent.getEnvironment().setVariableValue(this.var, list);
    }

    private Object getValue(Object obj, Class<?> vgtype, MatchContext context, RutaStream stream) {
        if (obj instanceof INumberExpression) {
            return ((INumberExpression)obj).getDoubleValue(context, stream);
        }
        if (obj instanceof IBooleanExpression) {
            return ((IBooleanExpression)obj).getBooleanValue(context, stream);
        }
        if (vgtype.equals(Type.class) && obj instanceof ITypeExpression) {
            return ((ITypeExpression)obj).getType(context, stream);
        }
        if (vgtype.equals(AnnotationFS.class) && obj instanceof IAnnotationExpression) {
            return ((IAnnotationExpression)obj).getAnnotation(context, stream);
        }
        if (obj instanceof IStringExpression) {
            return ((IStringExpression)obj).getStringValue(context, stream);
        }
        return obj;
    }
}

