/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MergeAction
extends AbstractRutaAction {
    private List<ListExpression> lists;
    private IBooleanExpression unionExpr;
    private String target;

    public MergeAction(IBooleanExpression union, String target, List<ListExpression> list) {
        this.unionExpr = union;
        this.target = target;
        this.lists = list;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        context.getRuleMatch();
        RuleElement element = context.getElement();
        boolean union = this.unionExpr.getBooleanValue(context, stream);
        ArrayList list = new ArrayList();
        if (union) {
            for (ListExpression each : this.lists) {
                list.addAll(each.getList(context, stream));
            }
        } else {
            List lastList = null;
            for (int i = 1; i < this.lists.size(); ++i) {
                List l2 = this.lists.get(i).getList(context, stream);
                if (lastList != null) {
                    lastList = ListUtils.intersection(lastList, l2);
                    continue;
                }
                List l1 = this.lists.get(i - 1).getList(context, stream);
                lastList = ListUtils.intersection(l1, l2);
            }
            list = lastList;
        }
        if (list != null) {
            element.getParent().getEnvironment().setVariableValue(this.target, list);
        }
    }

    public IBooleanExpression getUnion() {
        return this.unionExpr;
    }

    public List<ListExpression> getLists() {
        return this.lists;
    }

    public String getTarget() {
        return this.target;
    }
}

