/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class MacroAction
extends AbstractRutaAction {
    private final String name;
    private final Map<String, String> definition;
    private final List<AbstractRutaAction> actions;
    private final Set<String> vars;
    private final List<IRutaExpression> arguments;

    public MacroAction(String name, Map<String, String> definition, List<AbstractRutaAction> actions2, Set<String> vars, List<IRutaExpression> arguments) {
        this.name = name;
        this.definition = definition;
        this.actions = actions2;
        this.vars = vars;
        this.arguments = arguments;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        this.prepareEnvironment(context, stream);
        for (AbstractRutaAction eachAction : this.actions) {
            crowd.beginVisit(eachAction, null);
            eachAction.execute(context, stream, crowd);
            crowd.endVisit(eachAction, null);
        }
        this.cleanupEnvironment(context, stream);
    }

    private void prepareEnvironment(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Set<Map.Entry<String, String>> entrySet = this.definition.entrySet();
        int index = 0;
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            String type = entry.getValue();
            IRutaExpression expression = this.arguments.get(index);
            if (!this.vars.contains(name)) {
                environment.addVariable(name, type);
                stream.assignVariable(name, expression, context);
            } else {
                String var = environment.getVariableNameOfExpression(expression);
                environment.addAliasVariable(name, var);
            }
            ++index;
        }
    }

    private void cleanupEnvironment(MatchContext context, RutaStream stream) {
        RutaBlock parent = context.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        Set<Map.Entry<String, String>> entrySet = this.definition.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String name = entry.getKey();
            if (!this.vars.contains(name)) {
                environment.removeVariable(name);
                continue;
            }
            environment.removeAliasVariable(name);
        }
    }

    @Override
    public void setLabel(String label) {
        super.setLabel(label);
        for (AbstractRutaAction action : this.actions) {
            action.setLabel(label);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getDefinition() {
        return this.definition;
    }

    public List<AbstractRutaAction> getActions() {
        return this.actions;
    }

    public List<IRutaExpression> getArguments() {
        return this.arguments;
    }
}

