/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.LinkedList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.CallAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.visitor.InferenceCrowd;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLInputSource;

public class ExecAction
extends CallAction {
    private AbstractTypeListExpression typeList;
    private IStringExpression view;

    public ExecAction(String namespace) {
        super(namespace);
    }

    public ExecAction(String ns, AbstractTypeListExpression tl, IStringExpression view) {
        this(ns);
        this.typeList = tl;
        this.view = view;
    }

    @Override
    protected void callScript(RutaBlock block, MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        ScriptApply apply = block.apply(stream, crowd);
        context.getRuleMatch().addDelegateApply(this, apply);
    }

    @Override
    protected void callEngine(MatchContext context, InferenceCrowd crowd, AnalysisEngine targetEngine, RutaStream stream) throws ResourceInitializationException, AnalysisEngineProcessException {
        String viewName;
        CAS cas = stream.getCas();
        if (this.view != null && (viewName = this.view.getStringValue(context, stream)) != null && !viewName.equals("_InitialView")) {
            cas = cas.getView(viewName);
            AnalysisEngineMetaData metaData = targetEngine.getAnalysisEngineMetaData();
            try {
                String sourceUrlString = metaData.getSourceUrlString();
                if (sourceUrlString != null) {
                    AnalysisEngine createEngine;
                    AnalysisEngineDescription aed = (AnalysisEngineDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(sourceUrlString));
                    targetEngine = createEngine = AnalysisEngineFactory.createEngine(aed, viewName);
                }
            }
            catch (Exception e) {
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "Failed to initialize AnalysisEngine.", e);
            }
        }
        targetEngine.process(cas);
        if (this.typeList != null && this.view == null) {
            List list = this.typeList.getList(context, stream);
            for (Type type : list) {
                AnnotationIndex ai = cas.getAnnotationIndex(type);
                LinkedList<AnnotationFS> toUpdate = new LinkedList<AnnotationFS>();
                for (AnnotationFS annotationFS : ai) {
                    toUpdate.add(annotationFS);
                }
                for (AnnotationFS each : toUpdate) {
                    stream.removeAnnotation(each);
                }
                for (AnnotationFS each : toUpdate) {
                    stream.addAnnotation(each, true, context.getRuleMatch());
                }
            }
        }
    }

    public AbstractTypeListExpression getTypeList() {
        return this.typeList;
    }

    public IStringExpression getView() {
        return this.view;
    }

    public void setView(IStringExpression view) {
        this.view = view;
    }
}

