/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class CreateAction
extends AbstractStructureAction {
    private ITypeExpression structureType;
    private Map<IStringExpression, IRutaExpression> features;
    private List<INumberExpression> indexes;

    public CreateAction(ITypeExpression structureType, Map<IStringExpression, IRutaExpression> features, List<INumberExpression> indexes) {
        this.structureType = structureType;
        this.features = features == null ? new HashMap() : features;
        this.indexes = indexes == null || indexes.isEmpty() ? null : indexes;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        List<Integer> indexList = this.getIndexList(this.indexes, context, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotations(indexList, element.getContainer());
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            AnnotationFS annotation;
            if (matchedAnnotation == null) {
                return;
            }
            Type type = this.structureType.getType(context, stream);
            if (type == null || !((annotation = stream.getCas().createAnnotation(type, 0, 0)) instanceof Annotation)) continue;
            Annotation a = (Annotation)annotation;
            a.setBegin(matchedAnnotation.getBegin());
            a.setEnd(matchedAnnotation.getEnd());
            context.setAnnotation(matchedAnnotation);
            stream.assignFeatureValues(annotation, this.features, context);
            stream.addAnnotation(a, true, match);
            this.addAnnotationToLabel(a, context);
        }
    }

    public ITypeExpression getStructureType() {
        return this.structureType;
    }

    public Map<IStringExpression, IRutaExpression> getFeatures() {
        return this.features;
    }

    public List<INumberExpression> getIndexes() {
        return this.indexes;
    }
}

