/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.Type;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.AbstractBooleanListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.AbstractNumberListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ConfigureAction
extends AbstractRutaAction {
    private final String namespace;
    private final Map<IStringExpression, IRutaExpression> parameterMap;

    public ConfigureAction(String ns, Map<IStringExpression, IRutaExpression> map) {
        this.namespace = ns;
        this.parameterMap = map;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        RutaModule thisScript = parent.getScript();
        AnalysisEngine targetEngine = thisScript.getEngine(this.namespace);
        if (targetEngine == null) {
            throw new IllegalArgumentException("Analysis Engine with name '" + this.namespace + "' is unknown in script " + context.getParent().getName() + ".");
        }
        ConfigurationParameterDeclarations configurationParameterDeclarations = targetEngine.getAnalysisEngineMetaData().getConfigurationParameterDeclarations();
        Set<Map.Entry<IStringExpression, IRutaExpression>> entrySet = this.parameterMap.entrySet();
        for (Map.Entry<IStringExpression, IRutaExpression> entry : entrySet) {
            INumberExpression ne;
            ArrayList<Number> numbers;
            AbstractNumberListExpression nle;
            List<String> list;
            IStringExpression key = entry.getKey();
            String stringValue = key.getStringValue(context, stream);
            ConfigurationParameter configurationParameter = configurationParameterDeclarations.getConfigurationParameter(null, stringValue);
            if (configurationParameter == null) continue;
            IRutaExpression value = entry.getValue();
            String type = configurationParameter.getType();
            if (type.equals("String")) {
                ITypeExpression te;
                Type t;
                if (configurationParameter.isMultiValued()) {
                    if (value instanceof AbstractStringListExpression) {
                        AbstractStringListExpression sle = (AbstractStringListExpression)value;
                        list = sle.getList(context, stream);
                        targetEngine.setConfigParameterValue(stringValue, list.toArray(new String[0]));
                        continue;
                    }
                    if (!(value instanceof AbstractTypeListExpression)) continue;
                    AbstractTypeListExpression tle = (AbstractTypeListExpression)value;
                    list = tle.getList(context, stream);
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (Type type2 : list) {
                        stringList.add(type2.getName());
                    }
                    targetEngine.setConfigParameterValue(stringValue, stringList.toArray(new String[0]));
                    continue;
                }
                if (value instanceof IStringExpression) {
                    IStringExpression se = (IStringExpression)value;
                    String string = se.getStringValue(context, stream);
                    targetEngine.setConfigParameterValue(stringValue, string);
                    continue;
                }
                if (!(value instanceof ITypeExpression) || (t = (te = (ITypeExpression)value).getType(context, stream)) == null) continue;
                targetEngine.setConfigParameterValue(stringValue, t.getName());
                continue;
            }
            if (type.equals("Float")) {
                if (value instanceof AbstractNumberListExpression) {
                    nle = (AbstractNumberListExpression)value;
                    list = nle.getList(context, stream);
                    numbers = new ArrayList<Number>();
                    for (Number number : list) {
                        numbers.add(Float.valueOf(number.floatValue()));
                    }
                    targetEngine.setConfigParameterValue(stringValue, numbers.toArray());
                    continue;
                }
                if (!(value instanceof INumberExpression)) continue;
                ne = (INumberExpression)value;
                Double d = ne.getDoubleValue(context, stream);
                targetEngine.setConfigParameterValue(stringValue, Float.valueOf(d.floatValue()));
                continue;
            }
            if (type.equals("Integer")) {
                if (value instanceof AbstractNumberListExpression) {
                    nle = (AbstractNumberListExpression)value;
                    list = nle.getList(context, stream);
                    numbers = new ArrayList();
                    for (Number number : list) {
                        numbers.add(number.intValue());
                    }
                    targetEngine.setConfigParameterValue(stringValue, numbers.toArray());
                    continue;
                }
                if (!(value instanceof INumberExpression)) continue;
                ne = (INumberExpression)value;
                Integer i = ne.getIntegerValue(context, stream);
                targetEngine.setConfigParameterValue(stringValue, i);
                continue;
            }
            if (!type.equals("Boolean")) continue;
            if (value instanceof AbstractBooleanListExpression) {
                AbstractBooleanListExpression ble = (AbstractBooleanListExpression)value;
                list = ble.getList(context, stream);
                targetEngine.setConfigParameterValue(stringValue, list.toArray());
                continue;
            }
            if (!(value instanceof IBooleanExpression)) continue;
            IBooleanExpression be = (IBooleanExpression)value;
            Boolean b = be.getBooleanValue(context, stream);
            targetEngine.setConfigParameterValue(stringValue, b);
        }
        try {
            targetEngine.reconfigure();
        }
        catch (ResourceConfigurationException e) {
            e.printStackTrace();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<IStringExpression, IRutaExpression> getParameterMap() {
        return this.parameterMap;
    }
}

