/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.type.RutaColoring;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ColorAction
extends AbstractRutaAction {
    private IStringExpression bgcolor;
    private IStringExpression fgcolor;
    private IBooleanExpression selected;
    private ITypeExpression type;

    public ColorAction(ITypeExpression type, IStringExpression bgcolor, IStringExpression fgcolor, IBooleanExpression selected) {
        this.type = type;
        this.bgcolor = bgcolor == null ? new SimpleStringExpression("red") : bgcolor;
        this.fgcolor = fgcolor == null ? new SimpleStringExpression("red") : fgcolor;
        this.selected = selected == null ? new SimpleBooleanExpression(false) : selected;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleElement element = context.getElement();
        Type casType = stream.getJCas().getCasType(RutaColoring.type);
        Object newAnnotationFS = stream.getCas().createFS(casType);
        RutaColoring coloring = null;
        if (newAnnotationFS instanceof RutaColoring) {
            coloring = (RutaColoring)newAnnotationFS;
            element.getParent();
            coloring.setBgColor(this.bgcolor.getStringValue(context, stream));
            coloring.setFgColor(this.fgcolor.getStringValue(context, stream));
            coloring.setSelected(this.selected.getBooleanValue(context, stream));
            coloring.setTargetType(this.type.getType(context, stream).getName());
            coloring.addToIndexes();
        }
    }

    public IStringExpression getFgColor() {
        return this.fgcolor;
    }

    public IStringExpression getBgColor() {
        return this.bgcolor;
    }

    public IBooleanExpression getSelected() {
        return this.selected;
    }

    public ITypeExpression getType() {
        return this.type;
    }
}

