/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class AddAction
extends AbstractRutaAction {
    private String var;
    private List<IRutaExpression> elements;

    public AddAction(String var, List<IRutaExpression> list) {
        this.var = var;
        this.elements = list;
    }

    public String getListExpr() {
        return this.var;
    }

    public List<IRutaExpression> getElements() {
        return this.elements;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleElement element = context.getElement();
        RutaBlock parent = element.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        List list = environment.getVariableValue(this.var, List.class, stream);
        Class<?> vgtype = environment.getVariableGenericType(this.var);
        for (IRutaExpression each : this.elements) {
            if (vgtype.equals(Boolean.class) && each instanceof IBooleanExpression) {
                list.add(((IBooleanExpression)each).getBooleanValue(context, stream));
                continue;
            }
            if (vgtype.equals(Integer.class) && each instanceof INumberExpression) {
                list.add(((INumberExpression)each).getIntegerValue(context, stream));
                continue;
            }
            if (vgtype.equals(Double.class) && each instanceof INumberExpression) {
                list.add(((INumberExpression)each).getDoubleValue(context, stream));
                continue;
            }
            if (vgtype.equals(Type.class) && each instanceof ITypeExpression) {
                list.add(((ITypeExpression)each).getType(context, stream));
                continue;
            }
            if (vgtype.equals(String.class) && each instanceof IStringExpression) {
                list.add(((IStringExpression)each).getStringValue(context, stream));
                continue;
            }
            if (vgtype.equals(AnnotationFS.class) && each instanceof IAnnotationExpression) {
                AnnotationFS annotation = ((IAnnotationExpression)each).getAnnotation(context, stream);
                if (annotation == null) continue;
                list.add(annotation);
                continue;
            }
            if (!(each instanceof ListExpression)) continue;
            ListExpression l = (ListExpression)each;
            list.addAll(l.getList(context, stream));
        }
    }
}

