/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public abstract class AbstractRutaAction
extends RutaElement {
    private String label;

    public abstract void execute(MatchContext var1, RutaStream var2, InferenceCrowd var3);

    public String toString() {
        return this.getClass().getSimpleName();
    }

    protected List<Integer> getIndexList(List<INumberExpression> indexes, MatchContext context, RutaStream stream) {
        RuleElement element = context.getElement();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (indexes == null || indexes.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (INumberExpression each : indexes) {
            int value = each.getIntegerValue(context, stream);
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    protected void addAnnotationToLabel(AnnotationFS annotation, MatchContext context) {
        if (StringUtils.isBlank(this.label)) {
            return;
        }
        RutaEnvironment environment = context.getParent().getEnvironment();
        Class<?> variableType = environment.getVariableType(this.label);
        if (List.class.equals(variableType) && AnnotationFS.class.equals(environment.getVariableGenericType(this.label))) {
            environment.setVariableValue(this.label, Arrays.asList(annotation));
        } else if (AnnotationFS.class.equals(variableType)) {
            environment.setVariableValue(this.label, annotation);
        }
    }
}

