/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.TypeSensitiveAction;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;

public abstract class AbstractMarkAction
extends TypeSensitiveAction {
    public AbstractMarkAction(ITypeExpression type) {
        super(type);
    }

    protected Annotation createAnnotation(AnnotationFS annotation, MatchContext context, RutaStream stream) {
        Type t = this.type.getType(context, stream);
        if (t == null) {
            return null;
        }
        AnnotationFS newAnnotationFS = stream.getCas().createAnnotation(t, annotation.getBegin(), annotation.getEnd());
        Annotation newAnnotation = null;
        if (!(newAnnotationFS instanceof Annotation)) {
            return null;
        }
        newAnnotation = (Annotation)newAnnotationFS;
        newAnnotation.addToIndexes();
        stream.addAnnotation(newAnnotation, context.getRuleMatch());
        this.addAnnotationToLabel(newAnnotation, context);
        return newAnnotation;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.type.getClass().getSimpleName();
    }

    boolean getDictWSParamValue(MatchContext context) {
        Object configParameterValue = context.getParent().getContext().getConfigParameterValue("dictRemoveWS");
        if (configParameterValue instanceof Boolean) {
            return (Boolean)configParameterValue;
        }
        return false;
    }

    protected List<Integer> getIndexList(MatchContext context, List<INumberExpression> list, RutaStream stream) {
        RuleElement element = context.getElement();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            int self = element.getContainer().getRuleElements().indexOf(element) + 1;
            indexList.add(self);
            return indexList;
        }
        int last = 0x7FFFFFFE;
        for (INumberExpression each : list) {
            int value = each.getIntegerValue(context, stream);
            for (int i = Math.min(value, last + 1); i < value; ++i) {
                indexList.add(i);
            }
            indexList.add(value);
        }
        return indexList;
    }
}

