/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.antlr.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.TypeUsageInformation;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.ForEachBlock;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.block.RutaScriptBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.AnnotationTypeExpression;
import org.apache.uima.ruta.expression.ExpressionFactory;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.MatchReference;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.AbstractRuleElement;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.ConjunctRulesRuleElement;
import org.apache.uima.ruta.rule.RegExpRule;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementIsolator;
import org.apache.uima.ruta.rule.RutaAnnotationTypeMatcher;
import org.apache.uima.ruta.rule.RutaLiteralMatcher;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaOptionalRuleElement;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.WildCardRuleElement;
import org.apache.uima.ruta.rule.quantifier.MinMaxGreedy;
import org.apache.uima.ruta.rule.quantifier.MinMaxReluctant;
import org.apache.uima.ruta.rule.quantifier.PlusGreedy;
import org.apache.uima.ruta.rule.quantifier.PlusReluctant;
import org.apache.uima.ruta.rule.quantifier.QuestionGreedy;
import org.apache.uima.ruta.rule.quantifier.QuestionReluctant;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.rule.quantifier.StarGreedy;
import org.apache.uima.ruta.rule.quantifier.StarReluctant;

public class RutaScriptFactory {
    private int idCounter = 0;
    private UimaContext context;
    private ExpressionFactory expressionFactory;
    private TypeUsageInformation typeUsage;

    public RutaScriptFactory(ExpressionFactory expressionFactory, TypeUsageInformation typeUsage) {
        this.expressionFactory = expressionFactory == null ? new ExpressionFactory() : expressionFactory;
        this.typeUsage = typeUsage;
    }

    public RutaScriptFactory(ExpressionFactory expressionFactory) {
        this(expressionFactory, null);
    }

    public RutaScriptBlock createScriptBlock(Token id, RutaRuleElement ruleElement, List<RutaStatement> body, RutaBlock parent) {
        String text = id == null ? "root" : id.getText();
        String defaultNamespace = parent.getNamespace();
        if (id != null) {
            defaultNamespace = defaultNamespace + "." + text;
        }
        return this.createScriptBlock(text, ruleElement, body, parent, defaultNamespace);
    }

    public RutaScriptBlock createScriptBlock(String text, RutaRuleElement ruleElement, List<RutaStatement> body, RutaBlock parent, String defaultNamespace) {
        RutaRule rule = null;
        if (ruleElement != null) {
            rule = this.createRule(ruleElement, parent);
        }
        ArrayList<RutaStatement> elements = new ArrayList<RutaStatement>();
        if (body != null) {
            for (RutaStatement each : body) {
                if (each == null) continue;
                elements.add(each);
            }
        }
        return new RutaScriptBlock(text, rule, elements, parent, defaultNamespace);
    }

    public RutaScriptBlock createRootScriptBlock(String module, String pack) {
        String defaultNamespace = this.getDefaultNamespace(module, pack);
        RutaScriptBlock result = this.createScriptBlock(module, null, null, null, defaultNamespace);
        ArrayList<RuleElement> ruleElements = new ArrayList<RuleElement>();
        RuleElementIsolator container = new RuleElementIsolator();
        ITypeExpression documentExpression = this.expressionFactory.createSimpleTypeExpression("uima.tcas.DocumentAnnotation", null);
        MatchReference mr = this.expressionFactory.createMatchReference(documentExpression);
        ruleElements.add(this.createRuleElement(mr, container, result));
        RutaRule createRule = this.createRule(ruleElements, (RutaBlock)result);
        container.setContainer(createRule);
        result.setRule(createRule);
        result.setContext(this.context);
        return result;
    }

    private String getDefaultNamespace(String module, String pack) {
        String defaultNamespace = module;
        if (StringUtils.isBlank(module) && StringUtils.isBlank(pack)) {
            defaultNamespace = "";
        } else if (!StringUtils.isBlank(module) && !StringUtils.isBlank(pack)) {
            defaultNamespace = pack + "." + module;
        } else if (!StringUtils.isBlank(module)) {
            defaultNamespace = module;
        } else if (!StringUtils.isBlank(pack)) {
            defaultNamespace = pack;
        }
        return defaultNamespace;
    }

    public RutaBlock createForEachBlock(Token varToken, IBooleanExpression direction, RutaRuleElement ruleElement, List<RutaStatement> body, RutaBlock parent) {
        if (varToken == null) {
            throw new IllegalArgumentException("A FOREACH block requires that the annotation variable is named.");
        }
        String varName = varToken.getText();
        RutaRule rule = null;
        if (ruleElement != null) {
            rule = this.createRule(ruleElement, parent);
        }
        String namespace = parent.getNamespace() + "." + varName;
        return new ForEachBlock(varName, direction, rule, body, parent, namespace);
    }

    public RutaRule createRule(RuleElement element, RutaBlock parent) {
        ArrayList<RuleElement> elements = new ArrayList<RuleElement>();
        elements.add(element);
        return this.createRule(elements, parent);
    }

    public RutaStatement createImplicitRule(List<AbstractRutaAction> actions2, RutaBlock parent) {
        ArrayList<RuleElement> elements = new ArrayList<RuleElement>();
        ITypeExpression documentExpression = this.expressionFactory.createSimpleTypeExpression("Document", parent);
        MatchReference mr = this.expressionFactory.createMatchReference(documentExpression);
        RutaRuleElement element = this.createRuleElement(mr, null, null, actions2, null, parent);
        elements.add(element);
        RutaRule rule = this.createRule(elements, parent);
        element.setContainer(rule.getRoot());
        return rule;
    }

    public RutaRule createRule(List<RuleElement> elements, RutaBlock parent) {
        return new RutaRule(elements, parent, this.idCounter++);
    }

    public RutaRuleElement createRuleElement(MatchReference matchReference, RuleElementContainer container, RutaBlock parent) {
        return this.createRuleElement(matchReference, null, null, null, container, parent);
    }

    public RutaRuleElement createRuleElement(MatchReference matchReference, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        AnnotationTypeExpression expression = this.expressionFactory.createAnnotationTypeExpression(matchReference);
        return this.createRuleElement(expression, quantifier, conditions, actions2, container, parent);
    }

    public RutaRuleElement createRuleElement(IRutaExpression expression, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        RutaMatcher matcher = null;
        if (expression instanceof AnnotationTypeExpression) {
            matcher = new RutaAnnotationTypeMatcher((AnnotationTypeExpression)expression);
        } else if (expression instanceof IStringExpression) {
            matcher = new RutaLiteralMatcher((IStringExpression)expression);
        } else {
            throw new RuntimeException(expression.getClass().getSimpleName() + " is not a valid expression for a matching condition.");
        }
        return new RutaRuleElement(matcher, quantifier, conditions, actions2, container, parent);
    }

    public AbstractRuleElement createWildCardRuleElement(List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        return new WildCardRuleElement(conditions, actions2, container, parent);
    }

    public AbstractRuleElement createOptionalRuleElement(List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        return new RutaOptionalRuleElement(conditions, actions2, container, parent);
    }

    public ComposedRuleElement createComposedRuleElement(List<RuleElement> res, RuleElementQuantifier quantifier, List<AbstractRutaCondition> conditions, List<AbstractRutaAction> actions2, RuleElementContainer container, RutaBlock parent) {
        return new ComposedRuleElement(res, quantifier, conditions, actions2, container, parent);
    }

    public ComposedRuleElement createComposedRuleElement(RuleElementContainer container, RutaBlock parent) {
        return new ComposedRuleElement(null, null, null, null, container, parent);
    }

    public static RuleElementQuantifier createStarGreedyQuantifier() {
        return new StarGreedy();
    }

    public static RuleElementQuantifier createPlusReluctantQuantifier() {
        return new PlusReluctant();
    }

    public static RuleElementQuantifier createStarReluctantQuantifier() {
        return new StarReluctant();
    }

    public static RuleElementQuantifier createMinMaxGreedyQuantifier(INumberExpression min2, INumberExpression max, Token comma) {
        return new MinMaxGreedy(min2, max, comma != null);
    }

    public static RuleElementQuantifier createMinMaxReluctantQuantifier(INumberExpression min2, INumberExpression max, Token comma) {
        return new MinMaxReluctant(min2, max, comma != null);
    }

    public static RuleElementQuantifier createPlusGreedyQuantifier() {
        return new PlusGreedy();
    }

    public static RuleElementQuantifier createQuestionReluctantQuantifier() {
        return new QuestionReluctant();
    }

    public static RuleElementQuantifier createQuestionGreedyQuantifier() {
        return new QuestionGreedy();
    }

    public RutaBlock createAutomataBlock(Token id, RutaRuleElement re, List<RutaStatement> body, RutaBlock env) {
        return this.createScriptBlock(id, re, body, env);
    }

    public RegExpRule createRegExpRule(RutaBlock env) {
        return new RegExpRule(null, null, this.idCounter++, env);
    }

    public List<RuleElement> processConjunctRules(List<RuleElement> reList, List<Token> conList, RuleElementContainer container, RutaBlock env) {
        boolean isConjunct = false;
        for (Token token : conList) {
            if (token == null) continue;
            isConjunct = true;
            break;
        }
        if (!isConjunct) {
            return reList;
        }
        TreeMap map = new TreeMap();
        ArrayList<String> connectors = new ArrayList<String>();
        int reCounter = 0;
        int conCounter = 0;
        for (Token token : conList) {
            if (token == null) {
                List<RuleElement> list = (List)map.get(conCounter);
                if (list == null) {
                    list = new ArrayList<RuleElement>();
                    map.put(conCounter, list);
                }
                RuleElement e = reList.get(reCounter);
                list.add(e);
                ++reCounter;
                continue;
            }
            connectors.add(token.getText());
            ++conCounter;
        }
        ArrayList<RuleElement> elements = new ArrayList<RuleElement>();
        ConjunctRulesRuleElement cr = new ConjunctRulesRuleElement(null, container, env);
        for (List each : map.values()) {
            ComposedRuleElement cre = this.createComposedRuleElement(each, null, null, null, cr, env);
            for (RuleElement ruleElement : each) {
                ruleElement.setContainer(cre);
            }
            elements.add(cre);
        }
        cr.setElements(elements);
        cr.setContainer(null);
        ArrayList<RuleElement> result = new ArrayList<RuleElement>();
        result.add(cr);
        return result;
    }

    public UimaContext getContext() {
        return this.context;
    }

    public void setContext(UimaContext context) {
        this.context = context;
    }
}

